/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2014-2018 abel533@gmail.com
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
 * associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package querymethods.util;

import java.lang.reflect.Method;

import org.apache.ibatis.reflection.MetaObject;
import querymethods.QueryMethodsException;

/**
 * 来自 分页插件 PageHelper
 *
 * @author liuzh
 */
public class MetaObjectUtil {
  public static Method method;

  static {
    try {
      Class<?> metaClass = Class.forName("org.apache.ibatis.reflection.SystemMetaObject");
      method = metaClass.getDeclaredMethod("forObject", Object.class);
    } catch (Exception e1) {
      try {
        Class<?> metaClass = Class.forName("org.apache.ibatis.reflection.MetaObject");
        method = metaClass.getDeclaredMethod("forObject", Object.class);
      } catch (Exception e2) {
        throw new QueryMethodsException(e2);
      }
    }

  }

  public static MetaObject forObject(Object object) {
    try {
      return (MetaObject) method.invoke(null, object);
    } catch (Exception e) {
      throw new QueryMethodsException(e);
    }
  }

}
