/*
 * Decompiled with CFR 0.152.
 */
package querymethods.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import querymethods.QueryMethodsConfig;
import querymethods.QueryMethodsException;

public class MsIdUtil {
    private static Map<String, String> cacheMethodName = new HashMap<String, String>();
    private static Map<String, Class<?>> cacheMapperClass = new HashMap();
    private static Map<String, Class<?>> cacheEntityClass = new HashMap();

    private MsIdUtil() {
    }

    public static String getMethodName(String msId) {
        return cacheMethodName.getOrDefault(msId, MsIdUtil._getMethodName(msId));
    }

    private static String _getMethodName(String msId) {
        int lastIndexOf = msId.lastIndexOf(".");
        String methodName = msId.substring(lastIndexOf + 1);
        cacheMethodName.put(msId, methodName);
        return methodName;
    }

    public static Class<?> getMapperClass(String msId) {
        return cacheMapperClass.getOrDefault(msId, MsIdUtil._getMapperClass(msId));
    }

    private static Class<?> _getMapperClass(String msId) {
        int lastIndexOf = msId.lastIndexOf(".");
        String mapperName = msId.substring(0, lastIndexOf);
        try {
            Class<?> mapperClass = Class.forName(mapperName);
            cacheMapperClass.put(msId, mapperClass);
            return mapperClass;
        }
        catch (ClassNotFoundException e) {
            throw new QueryMethodsException(e);
        }
    }

    public static Class<?> getEntityClass(String msId) {
        return cacheEntityClass.getOrDefault(msId, MsIdUtil._getEntityClass(msId));
    }

    private static Class<?> _getEntityClass(String msId) {
        Class<?> entityClass = MsIdUtil.getEntityClass(MsIdUtil.getMapperClass(msId));
        cacheEntityClass.put(msId, entityClass);
        return entityClass;
    }

    public static Class<?> getEntityClass(Class<?> mapperClass) {
        Class<?> entityClass = null;
        Type[] genericInterfaces = mapperClass.getGenericInterfaces();
        if (genericInterfaces != null && genericInterfaces.length > 0) {
            for (Type type1 : genericInterfaces) {
                ParameterizedType t = (ParameterizedType)type1;
                if (!QueryMethodsConfig.getMapperClasss().contains(t.getRawType())) continue;
                try {
                    entityClass = Class.forName(t.getActualTypeArguments()[0].getTypeName());
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new QueryMethodsException(e);
                }
            }
        }
        return entityClass;
    }
}

