/*
 * Decompiled with CFR 0.152.
 */
package querymethods.spring.data.query.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import querymethods.spring.data.query.domain.Sort;
import querymethods.spring.data.query.parser.OrderBySource;
import querymethods.spring.data.query.parser.Part;
import querymethods.spring.data.util.Assert;
import querymethods.spring.data.util.StringUtils;

public class PartTree
implements Iterable<OrPart> {
    private static final String KEYWORD_TEMPLATE = "(%s)(?=(\\p{Lu}|\\P{InBASIC_LATIN}))";
    private static final String QUERY_PATTERN = "find|read|get|query|stream";
    private static final String COUNT_PATTERN = "count";
    private static final String EXISTS_PATTERN = "exists";
    private static final String DELETE_PATTERN = "delete|remove";
    private static final Pattern PREFIX_TEMPLATE = Pattern.compile("^(find|read|get|query|stream|count|exists|delete|remove)((\\p{Lu}.*?))??By");
    private final Subject subject;
    private final Predicate predicate;

    public PartTree(String source) {
        Assert.notNull(source, "Source must not be null");
        Matcher matcher = PREFIX_TEMPLATE.matcher(source);
        if (!matcher.find()) {
            this.subject = new Subject(null);
            this.predicate = new Predicate(source);
        } else {
            this.subject = new Subject(matcher.group(0));
            this.predicate = new Predicate(source.substring(matcher.group().length()));
        }
    }

    @Override
    public Iterator<OrPart> iterator() {
        return this.predicate.iterator();
    }

    public Sort getSort() {
        OrderBySource orderBySource = this.predicate.getOrderBySource();
        return orderBySource == null ? null : orderBySource.toSort();
    }

    public boolean isDistinct() {
        return this.subject.isDistinct();
    }

    public Boolean isCountProjection() {
        return this.subject.isCountProjection();
    }

    public Boolean isExistsProjection() {
        return this.subject.isExistsProjection();
    }

    public Boolean isDelete() {
        return this.subject.isDelete();
    }

    public boolean isLimiting() {
        return this.getMaxResults() != null;
    }

    public Integer getMaxResults() {
        return this.subject.getMaxResults();
    }

    public String getQueryProperty() {
        return this.subject.getQueryProperty();
    }

    public Iterable<Part> getParts() {
        ArrayList<Part> result = new ArrayList<Part>();
        for (OrPart orPart : this) {
            for (Part part : orPart) {
                result.add(part);
            }
        }
        return result;
    }

    public Iterable<Part> getParts(Part.Type type) {
        ArrayList<Part> result = new ArrayList<Part>();
        for (Part part : this.getParts()) {
            if (!part.getType().equals((Object)type)) continue;
            result.add(part);
        }
        return result;
    }

    public String toString() {
        OrderBySource orderBySource = this.predicate.getOrderBySource();
        return String.format("%s%s", StringUtils.collectionToDelimitedString(this.predicate.nodes, " or "), orderBySource == null ? "" : " " + orderBySource);
    }

    private static String[] split(String text, String keyword) {
        Pattern pattern = Pattern.compile(String.format(KEYWORD_TEMPLATE, keyword));
        return pattern.split(text);
    }

    private static class Predicate {
        private static final Pattern ALL_IGNORE_CASE = Pattern.compile("AllIgnor(ing|e)Case");
        private static final String ORDER_BY = "OrderBy";
        private final List<OrPart> nodes = new ArrayList<OrPart>();
        private final OrderBySource orderBySource;
        private boolean alwaysIgnoreCase;

        public Predicate(String predicate) {
            String[] parts = PartTree.split(this.detectAndSetAllIgnoreCase(predicate), ORDER_BY);
            if (parts.length > 2) {
                throw new IllegalArgumentException("OrderBy must not be used more than once in a method name!");
            }
            this.buildTree(parts[0]);
            this.orderBySource = parts.length == 2 ? new OrderBySource(parts[1]) : null;
        }

        private String detectAndSetAllIgnoreCase(String predicate) {
            Matcher matcher = ALL_IGNORE_CASE.matcher(predicate);
            if (matcher.find()) {
                this.alwaysIgnoreCase = true;
                predicate = predicate.substring(0, matcher.start()) + predicate.substring(matcher.end(), predicate.length());
            }
            return predicate;
        }

        private void buildTree(String source) {
            String[] split;
            for (String part : split = PartTree.split(source, "Or")) {
                this.nodes.add(new OrPart(part, this.alwaysIgnoreCase));
            }
        }

        public Iterator<OrPart> iterator() {
            return this.nodes.iterator();
        }

        public OrderBySource getOrderBySource() {
            return this.orderBySource;
        }
    }

    private static class Subject {
        private static final String DISTINCT = "Distinct";
        private static final Pattern COUNT_BY_TEMPLATE = Pattern.compile("^count(\\p{Lu}.*?)??By");
        private static final Pattern EXISTS_BY_TEMPLATE = Pattern.compile("^(exists)(\\p{Lu}.*?)??By");
        private static final Pattern DELETE_BY_TEMPLATE = Pattern.compile("^(delete|remove)(\\p{Lu}.*?)??By");
        private static final String LIMITING_QUERY_PATTERN = "(First|Top)(\\d*)?";
        private static final Pattern LIMITED_QUERY_TEMPLATE = Pattern.compile("^(find|read|get|query|stream)(Distinct)?(First|Top)(\\d*)?(\\p{Lu}.*?)??By");
        private final boolean distinct;
        private final boolean count;
        private final boolean exists;
        private final boolean delete;
        private final Integer maxResults;
        private static final Pattern QUERY_BY_TEMPLATE = Pattern.compile("^(find|read|get|query|stream)(\\p{Lu}.*?)??By");
        private final String queryProperty;

        public Subject(String subject) {
            this.distinct = subject == null ? false : subject.contains(DISTINCT);
            this.count = this.matches(subject, COUNT_BY_TEMPLATE);
            this.exists = this.matches(subject, EXISTS_BY_TEMPLATE);
            this.delete = this.matches(subject, DELETE_BY_TEMPLATE);
            this.maxResults = this.returnMaxResultsIfFirstKSubjectOrNull(subject);
            this.queryProperty = this.findQueryProperty(subject);
        }

        private String findQueryProperty(String subject) {
            if (null == subject) {
                return null;
            }
            if (this.matches(subject, QUERY_BY_TEMPLATE)) {
                String property = Pattern.compile("^(find|read|get|query|stream)|By$", 32).matcher(subject).replaceAll("");
                if (StringUtils.isEmpty(property)) {
                    return null;
                }
                property = property.replace(DISTINCT, "");
                return StringUtils.uncapitalize(property);
            }
            return null;
        }

        private Integer returnMaxResultsIfFirstKSubjectOrNull(String subject) {
            if (subject == null) {
                return null;
            }
            Matcher grp = LIMITED_QUERY_TEMPLATE.matcher(subject);
            if (!grp.find()) {
                return null;
            }
            return StringUtils.hasText(grp.group(4)) ? Integer.valueOf(grp.group(4)) : 1;
        }

        public Boolean isDelete() {
            return this.delete;
        }

        public boolean isCountProjection() {
            return this.count;
        }

        public boolean isExistsProjection() {
            return this.exists;
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        public Integer getMaxResults() {
            return this.maxResults;
        }

        public String getQueryProperty() {
            return this.queryProperty;
        }

        private final boolean matches(String subject, Pattern pattern) {
            return subject == null ? false : pattern.matcher(subject).find();
        }
    }

    public static class OrPart
    implements Iterable<Part> {
        private final List<Part> children = new ArrayList<Part>();

        OrPart(String source, boolean alwaysIgnoreCase) {
            String[] split;
            for (String part : split = PartTree.split(source, "And")) {
                if (!StringUtils.hasText(part)) continue;
                this.children.add(new Part(part, alwaysIgnoreCase));
            }
        }

        @Override
        public Iterator<Part> iterator() {
            return this.children.iterator();
        }

        public String toString() {
            return StringUtils.collectionToDelimitedString(this.children, " and ");
        }
    }
}

