/*
 * Decompiled with CFR 0.152.
 */
package querymethods.mybatisplus;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.Collection;
import java.util.Queue;
import org.apache.ibatis.binding.MapperMethod;
import querymethods.mybatisplus.MPTableInfo;
import querymethods.mybatisplus.MybatisPlusUtil;
import querymethods.spring.data.PartTreeFactory;
import querymethods.spring.data.mapping.PropertyPath;
import querymethods.spring.data.query.domain.Sort;
import querymethods.spring.data.query.parser.Part;
import querymethods.spring.data.query.parser.PartTree;
import querymethods.util.MsIdUtil;

public class MybatisPlusWhereFactory {
    public static MapperMethod.ParamMap<Object> getExampleByMsId(String msId, Queue<Object> params) throws ClassNotFoundException {
        String queryProperty;
        Class<?> entityClass = MsIdUtil.getEntityClass(msId);
        String methodName = MsIdUtil.getMethodName(msId);
        PartTree tree = PartTreeFactory.create(msId, methodName);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.getSqlSelect();
        TableInfo tbInfo = MybatisPlusUtil.getTableInfo(entityClass);
        MPTableInfo tableInfo = MybatisPlusUtil.getMPTableInfo(entityClass);
        String sqlSelect = "";
        if (tree.isDistinct()) {
            sqlSelect = " distinct ";
        }
        if (StringUtils.isNotBlank((CharSequence)(queryProperty = tree.getQueryProperty()))) {
            sqlSelect = sqlSelect + tableInfo.getColumnByProperty(queryProperty);
        } else if (tree.isDistinct()) {
            sqlSelect = sqlSelect + tbInfo.getAllSqlSelect();
        }
        if (!"".equals(sqlSelect)) {
            wrapper.select(new String[]{sqlSelect});
        }
        MybatisPlusWhereFactory.build(params, tree, wrapper, tableInfo, msId);
        Sort sort = tree.getSort();
        if (sort != null) {
            for (Sort.Order order : sort) {
                if (order.isAscending()) {
                    wrapper.orderByAsc((Object)order.getProperty());
                    continue;
                }
                wrapper.orderByDesc((Object)order.getProperty());
            }
        }
        MapperMethod.ParamMap pm = new MapperMethod.ParamMap();
        pm.put((Object)"ew", (Object)wrapper);
        return pm;
    }

    private static void build(Queue<Object> params, PartTree tree, QueryWrapper<?> wrapper, MPTableInfo tableInfo, String msId) {
        int index = 0;
        for (PartTree.OrPart node : tree) {
            if (index == 0) {
                MybatisPlusWhereFactory.andSql(params, wrapper, node, tableInfo, msId);
            } else {
                wrapper.or(i -> MybatisPlusWhereFactory.andSql(params, i, node, tableInfo, msId));
            }
            ++index;
        }
    }

    private static void andSql(Queue<Object> params, QueryWrapper<?> wrapper, PartTree.OrPart node, MPTableInfo tableInfo, String msId) {
        for (Part part : node) {
            MybatisPlusWhereFactory.build(part, wrapper, params, tableInfo, msId);
        }
    }

    public static void build(Part part, QueryWrapper root, Queue<Object> args, MPTableInfo tableInfo, String msId) {
        PropertyPath pp = part.getProperty();
        Part.Type type = part.getType();
        String property = pp.getSegment();
        String column = tableInfo.getColumnByProperty(property);
        switch (type) {
            case BETWEEN: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                Object b = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.between((Object)column, a, b);
                break;
            }
            case AFTER: 
            case GREATER_THAN: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.gt((Object)column, a);
                break;
            }
            case GREATER_THAN_EQUAL: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.ge((Object)column, a);
                break;
            }
            case BEFORE: 
            case LESS_THAN: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.lt((Object)column, a);
                break;
            }
            case LESS_THAN_EQUAL: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.le((Object)column, a);
                break;
            }
            case IS_NULL: {
                root.isNull((Object)column);
                break;
            }
            case IS_NOT_NULL: {
                root.isNotNull((Object)column);
                break;
            }
            case NOT_IN: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.notIn((Object)column, ((Collection)a).toArray());
                break;
            }
            case IN: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.in((Object)column, ((Collection)a).toArray());
                break;
            }
            case STARTING_WITH: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.likeLeft((Object)column, a);
                break;
            }
            case ENDING_WITH: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.likeRight((Object)column, a);
                break;
            }
            case CONTAINING: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.like((Object)column, a);
                break;
            }
            case NOT_CONTAINING: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.notLike((Object)column, a);
                break;
            }
            case LIKE: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.apply(column + " like {0}", new Object[]{a});
                break;
            }
            case NOT_LIKE: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.apply(column + " not like {0}", new Object[]{a});
                break;
            }
            case TRUE: {
                root.eq((Object)column, (Object)1);
                break;
            }
            case FALSE: {
                root.eq((Object)column, (Object)0);
                break;
            }
            case SIMPLE_PROPERTY: {
                Object a = args.poll();
                if (a == null) {
                    root.isNull((Object)column);
                    break;
                }
                root.eq((Object)column, a);
                break;
            }
            case NEGATING_SIMPLE_PROPERTY: {
                Object a = args.poll();
                if (a == null) {
                    root.isNotNull((Object)column);
                    break;
                }
                root.ne((Object)column, a);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported keyword " + (Object)((Object)type));
            }
        }
    }

    static Object checkNotNull(String property, Queue<Object> args, String msId) {
        Object param = args.poll();
        if (param == null) {
            throw new IllegalArgumentException("Value must not be null! [" + property + " -> " + msId + "]");
        }
        return param;
    }
}

