/*
 * Decompiled with CFR 0.152.
 */
package querymethods.intercepts;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.defaults.DefaultSqlSession;
import querymethods.QueryMethodsConfig;
import querymethods.QueryMethodsException;
import querymethods.QueryMethodsHelper;
import querymethods.mybatisplus.MybatisPlusWhereFactory;
import querymethods.tkmapper.TkMapperWhereFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class QueryMethodsInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Executor executor = (Executor)invocation.getTarget();
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        String msId = ms.getId();
        if (QueryMethodsHelper.isQueryMethod(msId)) {
            Object parameter = args[1];
            RowBounds rbs = (RowBounds)args[2];
            ResultHandler rh = (ResultHandler)args[3];
            Object example = this.getExample(msId, parameter);
            return invocation.getMethod().invoke((Object)executor, ms, example, rbs, rh);
        }
        if (QueryMethodsHelper.isDeleteMethod(msId)) {
            Object parameter = args[1];
            Object example = this.getExample(msId, parameter);
            return invocation.getMethod().invoke((Object)executor, ms, example);
        }
        return invocation.proceed();
    }

    private Object getExample(String msId, Object parameter) throws ClassNotFoundException {
        MapperMethod.ParamMap<Object> example;
        MapperMethod.ParamMap pm;
        LinkedList<Object> params = new LinkedList<Object>();
        if (parameter instanceof MapperMethod.ParamMap) {
            pm = (MapperMethod.ParamMap)parameter;
            String regex = "^param(\\d)+$";
            Object[] keys = pm.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (Object key : keys) {
                if (!((String)key).matches(regex)) continue;
                params.add(pm.get(key));
            }
        } else if (parameter instanceof DefaultSqlSession.StrictMap) {
            pm = (DefaultSqlSession.StrictMap)parameter;
            Object[] keys = pm.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (Object key : keys) {
                params.add(pm.get(key));
            }
        } else {
            params.add(parameter);
        }
        if (QueryMethodsConfig.isTkMapper()) {
            example = TkMapperWhereFactory.getExampleByMsId(msId, params);
            return example;
        }
        if (QueryMethodsConfig.isMybatisPlus()) {
            example = MybatisPlusWhereFactory.getExampleByMsId(msId, params);
            return example;
        }
        throw new QueryMethodsException("no orm find tkmapper or mybatis-plus");
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

