/*
 * Decompiled with CFR 0.152.
 */
package querymethods.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import querymethods.query.domain.Sort;
import querymethods.query.util.StringUtils;

public class OrderBySource {
    private static final String BLOCK_SPLIT = "(?<=Asc|Desc)(?=\\p{Lu})";
    private static final Pattern DIRECTION_SPLIT = Pattern.compile("(.+?)(Asc|Desc)?$");
    private static final String INVALID_ORDER_SYNTAX = "Invalid order syntax for part %s!";
    private static final Set<String> DIRECTION_KEYWORDS = new HashSet<String>(Arrays.asList("Asc", "Desc"));
    private final List<Sort.Order> orders = new ArrayList<Sort.Order>();

    public OrderBySource(String clause) {
        for (String part : clause.split(BLOCK_SPLIT)) {
            Matcher matcher = DIRECTION_SPLIT.matcher(part);
            if (!matcher.find()) {
                throw new IllegalArgumentException(String.format(INVALID_ORDER_SYNTAX, part));
            }
            String propertyString = matcher.group(1);
            String directionString = matcher.group(2);
            if (DIRECTION_KEYWORDS.contains(propertyString) && directionString == null) {
                throw new IllegalArgumentException(String.format(INVALID_ORDER_SYNTAX, part));
            }
            Sort.Direction direction = StringUtils.hasText(directionString) ? Sort.Direction.fromString(directionString) : null;
            this.orders.add(this.createOrder(propertyString, direction));
        }
    }

    private Sort.Order createOrder(String propertySource, Sort.Direction direction) {
        return new Sort.Order(direction, StringUtils.uncapitalize(propertySource));
    }

    public Sort toSort() {
        return this.orders.isEmpty() ? null : new Sort(this.orders);
    }

    public String toString() {
        return "Order By " + StringUtils.collectionToDelimitedString(this.orders, ", ");
    }
}

