/*
 * Decompiled with CFR 0.152.
 */
package querymethods;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.session.Configuration;
import querymethods.util.SqlUtil;
import tk.mybatis.mapper.mapperhelper.MapperHelper;

public class QueryMethodsHelper {
    private static final Map<String, Boolean> queryMethod = new HashMap<String, Boolean>();

    private QueryMethodsHelper() {
    }

    public static boolean isQueryMethods(String msId) {
        return queryMethod.containsKey(msId);
    }

    public static void processConfiguration(Configuration configuration, MapperHelper mapperHelper) {
        Collection mappedStatements = configuration.getMappedStatements();
        for (Object object : mappedStatements) {
            MappedStatement ms;
            SqlSource sqlSource;
            if (!(object instanceof MappedStatement) || (sqlSource = (ms = (MappedStatement)object).getSqlSource()) instanceof ProviderSqlSource || sqlSource instanceof DynamicSqlSource) continue;
            String msId = ms.getId();
            BoundSql boundSql = sqlSource.getBoundSql(null);
            String sql = boundSql.getSql();
            if (!SqlCommandType.SELECT.equals((Object)ms.getSqlCommandType()) || !"".equals(sql)) continue;
            try {
                queryMethod.put(msId, Boolean.TRUE);
                String xmlSql = SqlUtil.getSqlByMsId(msId, mapperHelper.getConfig());
                LanguageDriver defaultDriver = configuration.getLanguageRegistry().getDefaultDriver();
                SqlSource s = defaultDriver.createSqlSource(ms.getConfiguration(), xmlSql, null);
                MetaObject msObject = SystemMetaObject.forObject((Object)ms);
                msObject.setValue("sqlSource", (Object)s);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

