/*
 * Decompiled with CFR 0.152.
 */
package com.ftf.coral.lock.spring.boot.autoconfigure;

import com.ftf.coral.lock.DistributedLock;
import com.ftf.coral.lock.redis.RedisDistributedLock;
import com.ftf.coral.lock.spring.boot.autoconfigure.properties.LockProperties;
import com.ftf.coral.spring.boot.autoconfigure.CoralAutoConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@EnableConfigurationProperties(value={LockProperties.class})
@ConditionalOnProperty(prefix="coral.lock", name={"enabled"}, havingValue="true")
@AutoConfigureAfter(value={CoralAutoConfiguration.class, RedisAutoConfiguration.class})
public class LockAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockAutoConfiguration.class);
    LockProperties properties;

    public LockAutoConfiguration(LockProperties properties) {
        this.properties = properties;
        LOGGER.info("\u5206\u5e03\u5f0f\u9501\u6a21\u5757\u5df2\u5f00\u542f");
    }

    @Bean
    public DistributedLock distributedLock(StringRedisTemplate redisTemplate) {
        return new RedisDistributedLock(redisTemplate);
    }
}

