/*
 * Decompiled with CFR 0.152.
 */
package com.ftf.coral.lock.redis;

import com.ftf.coral.lock.AbstractDistributedLock;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.types.Expiration;

public class RedisDistributedLock
extends AbstractDistributedLock {
    private static final Logger logger = LoggerFactory.getLogger(RedisDistributedLock.class);
    @Autowired
    private StringRedisTemplate redisTemplate;
    private ThreadLocal<String> lockFlag = new ThreadLocal();
    private static final String UNLOCK_LUA = "if redis.call(\"get\",KEYS[1]) == ARGV[1] then     return redis.call(\"del\",KEYS[1]) else     return 0 end ";

    public RedisDistributedLock(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public boolean lock(String key, long expire, int retryTimes, long sleepMillis) {
        boolean result = this.setRedis(key, expire);
        while (!result && retryTimes-- > 0) {
            try {
                logger.debug("get redisDistributeLock failed, retrying..." + retryTimes);
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted!", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            result = this.setRedis(key, expire);
        }
        return result;
    }

    private boolean setRedis(String key, long expire) {
        try {
            boolean status = (Boolean)this.redisTemplate.execute(connection -> {
                String uuid = UUID.randomUUID().toString();
                this.lockFlag.set(uuid);
                byte[] keyByte = this.redisTemplate.getStringSerializer().serialize((Object)key);
                byte[] uuidByte = this.redisTemplate.getStringSerializer().serialize((Object)uuid);
                boolean result = connection.set(keyByte, uuidByte, Expiration.from((long)expire, (TimeUnit)TimeUnit.MILLISECONDS), RedisStringCommands.SetOption.ifAbsent());
                return result;
            });
            return status;
        }
        catch (Exception e) {
            logger.error("set redisDistributeLock occured an exception", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean releaseLock(String key) {
        try {
            Boolean result = (Boolean)this.redisTemplate.execute(connection -> {
                byte[] scriptByte = this.redisTemplate.getStringSerializer().serialize((Object)UNLOCK_LUA);
                return (Boolean)connection.eval(scriptByte, ReturnType.BOOLEAN, 1, (byte[][])new byte[][]{this.redisTemplate.getStringSerializer().serialize((Object)key), this.redisTemplate.getStringSerializer().serialize((Object)this.lockFlag.get())});
            });
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            logger.error("release redisDistributeLock occured an exception", (Throwable)e);
        }
        finally {
            this.lockFlag.remove();
        }
        return false;
    }
}

