/*
 * Decompiled with CFR 0.152.
 */
package ro.skyah.comparator.matcher;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import ro.skyah.comparator.CompareMode;
import ro.skyah.comparator.matcher.AbstractJsonMatcher;
import ro.skyah.comparator.matcher.JsonMatcher;
import ro.skyah.comparator.matcher.MatcherException;

public class JsonObjectMatcher
extends AbstractJsonMatcher {
    private Set<String> matchedFieldNames = new HashSet<String>();

    public JsonObjectMatcher(JsonNode expected, JsonNode actual) {
        super(expected, actual);
    }

    @Override
    public void matches() throws MatcherException {
        Iterator it = this.expected.fields();
        block2: while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String field = (String)entry.getKey();
            JsonNode expectedValue = (JsonNode)entry.getValue();
            AbstractJsonMatcher.UseCase fieldUseCase = this.getUseCase(field);
            String sanitizedField = this.sanitize(field);
            List<Map.Entry<String, JsonNode>> candidateEntries = this.searchCandidateEntriesByField(sanitizedField, this.actual);
            if (fieldUseCase.equals((Object)AbstractJsonMatcher.UseCase.DO_NOT_MATCH) && candidateEntries.isEmpty()) continue;
            if (fieldUseCase.equals((Object)AbstractJsonMatcher.UseCase.DO_NOT_MATCH) && !candidateEntries.isEmpty()) {
                throw new MatcherException(String.format("Field %s was found", field));
            }
            if (fieldUseCase.equals((Object)AbstractJsonMatcher.UseCase.MATCH) && candidateEntries.isEmpty()) {
                throw new MatcherException(String.format("Field %s was not found", field));
            }
            ListIterator<Map.Entry<String, JsonNode>> it1 = candidateEntries.listIterator();
            while (it1.hasNext()) {
                Map.Entry<String, JsonNode> candidateEntry = it1.next();
                String candidateField = candidateEntry.getKey();
                JsonNode candidateValue = candidateEntry.getValue();
                try {
                    new JsonMatcher(expectedValue, candidateValue).matches();
                }
                catch (MatcherException e) {
                    if (it1.hasNext()) continue;
                    throw new MatcherException(String.format("%s <- field \"%s\"", e.getMessage(), sanitizedField));
                }
                this.matchedFieldNames.add(candidateField);
                continue block2;
            }
        }
        if (compareModes.contains((Object)CompareMode.JSON_OBJECT_NON_EXTENSIBLE) && this.expected.size() < this.actual.size()) {
            throw new MatcherException("Actual JSON OBJECT has extra fields");
        }
    }

    private List<Map.Entry<String, JsonNode>> searchCandidateEntriesByField(String fieldName, JsonNode target) {
        ArrayList<Map.Entry<String, JsonNode>> candidatesList = new ArrayList<Map.Entry<String, JsonNode>>();
        Iterator it = target.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String key = (String)entry.getKey();
            if (this.matchedFieldNames.contains(key) || !comparator.compareFields(fieldName, key)) continue;
            candidatesList.add(entry);
        }
        return candidatesList;
    }
}

