/*
 * Decompiled with CFR 0.152.
 */
package ro.skyah.comparator.matcher;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Set;
import ro.skyah.comparator.CompareMode;
import ro.skyah.comparator.JsonComparator;
import ro.skyah.comparator.matcher.AbstractJsonMatcher;
import ro.skyah.comparator.matcher.JsonArrayMatcher;
import ro.skyah.comparator.matcher.JsonObjectMatcher;
import ro.skyah.comparator.matcher.JsonTextMatcher;
import ro.skyah.comparator.matcher.MatcherException;

public class JsonMatcher
extends AbstractJsonMatcher {
    public JsonMatcher(JsonNode expected, JsonNode actual) {
        super(expected, actual);
    }

    public JsonMatcher(JsonNode expected, JsonNode actual, JsonComparator jsonComparator, Set<CompareMode> jsonCompareModes) {
        super(expected, actual, jsonComparator, jsonCompareModes);
    }

    @Override
    public void matches() throws MatcherException {
        if (JsonMatcher.isJsonObject(this.expected) && JsonMatcher.isJsonObject(this.actual)) {
            new JsonObjectMatcher(this.expected, this.actual).matches();
        } else if (JsonMatcher.isJsonArray(this.expected) && JsonMatcher.isJsonArray(this.actual)) {
            new JsonArrayMatcher(this.expected, this.actual).matches();
        } else if (JsonMatcher.isJsonText(this.expected) && JsonMatcher.isJsonText(this.actual)) {
            new JsonTextMatcher(this.expected, this.actual).matches();
        } else {
            throw new MatcherException("Different JSON types");
        }
    }
}

