/*
 * Decompiled with CFR 0.152.
 */
package ro.skyah.comparator.matcher;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ro.skyah.comparator.CompareMode;
import ro.skyah.comparator.DefaultJsonComparator;
import ro.skyah.comparator.JsonComparator;
import ro.skyah.comparator.matcher.MatcherException;

public abstract class AbstractJsonMatcher {
    protected static Set<CompareMode> compareModes = new HashSet<CompareMode>();
    protected static JsonComparator comparator = new DefaultJsonComparator();
    protected JsonNode expected;
    protected JsonNode actual;

    public AbstractJsonMatcher(JsonNode expected, JsonNode actual) {
        this.expected = expected;
        this.actual = actual;
    }

    public AbstractJsonMatcher(JsonNode expected, JsonNode actual, JsonComparator jsonComparator, Set<CompareMode> jsonCompareModes) {
        this(expected, actual);
        compareModes = jsonCompareModes;
        comparator = jsonComparator;
    }

    public abstract void matches() throws MatcherException;

    protected UseCase getUseCase(JsonNode node) {
        block4: {
            block3: {
                if (node.isValueNode()) {
                    return this.getUseCase(node.asText());
                }
                if (!node.isArray()) break block3;
                ArrayNode arrayNode = (ArrayNode)node;
                for (int i = 0; i < arrayNode.size(); ++i) {
                    if (!this.getUseCase(arrayNode.get(i)).equals((Object)UseCase.MATCH)) continue;
                    return UseCase.MATCH;
                }
                break block4;
            }
            if (!node.isObject()) break block4;
            ObjectNode objectNode = (ObjectNode)node;
            Iterator it = objectNode.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                if (!this.getUseCase((String)entry.getKey()).equals((Object)UseCase.MATCH) || !this.getUseCase((JsonNode)entry.getValue()).equals((Object)UseCase.MATCH)) continue;
                return UseCase.MATCH;
            }
        }
        return UseCase.DO_NOT_MATCH;
    }

    protected UseCase getUseCase(String value) {
        if (value == null || value.length() == 0 || !value.substring(0, 1).equals("!")) {
            return UseCase.MATCH;
        }
        return UseCase.DO_NOT_MATCH;
    }

    protected String sanitize(String value) {
        if (this.getUseCase(value).equals((Object)UseCase.DO_NOT_MATCH)) {
            return value.substring(1);
        }
        return AbstractJsonMatcher.removeEscapedUseCase(value);
    }

    private static String removeEscapedUseCase(String value) {
        if (value == null) {
            return value;
        }
        if (value.matches("^(\\\\*)!.*$")) {
            return value.replaceFirst("\\\\\\\\\\\\", "");
        }
        return value;
    }

    protected static boolean isJsonObject(JsonNode jsonNode) {
        if (jsonNode == null) {
            return false;
        }
        return jsonNode.getNodeType().equals((Object)JsonNodeType.OBJECT);
    }

    protected static boolean isJsonArray(JsonNode jsonNode) {
        if (jsonNode == null) {
            return false;
        }
        return jsonNode.getNodeType().equals((Object)JsonNodeType.ARRAY);
    }

    protected static boolean isJsonText(JsonNode jsonNode) {
        JsonNodeType type = jsonNode.getNodeType();
        return type.equals((Object)JsonNodeType.STRING) || type.equals((Object)JsonNodeType.NUMBER) || type.equals((Object)JsonNodeType.BOOLEAN) || type.equals((Object)JsonNodeType.NULL);
    }

    public static enum UseCase {
        MATCH,
        DO_NOT_MATCH;

    }
}

