/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Attribute;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MissingValuesImputation;
import weka.filters.unsupervised.attribute.missingvaluesimputation.Imputation;
import weka.filters.unsupervised.attribute.missingvaluesimputation.MeansAndModes;

public class MissingValuesImputationTest
extends AbstractFilterTest {
    public MissingValuesImputationTest(String name) {
        super(name);
        System.setProperty("weka.test.Regression.root", "src/test/resources");
    }

    public Filter getFilter() {
        return new MissingValuesImputation();
    }

    public void testTypical() {
        Instances result = this.useFilter();
        MissingValuesImputationTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MissingValuesImputationTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        for (int j = 0; j < this.m_Instances.numAttributes(); ++j) {
            Attribute inatt = this.m_Instances.attribute(j);
            Attribute outatt = result.attribute(j);
            for (int i = 0; i < this.m_Instances.numInstances(); ++i) {
                if (!this.m_Instances.attribute(j).isString()) continue;
                if (this.m_Instances.instance(i).isMissing(j)) {
                    MissingValuesImputationTest.assertTrue((String)"Missing values in strings cannot be replaced", (boolean)result.instance(i).isMissing(j));
                    continue;
                }
                MissingValuesImputationTest.assertEquals((String)"String values should not have changed", (String)inatt.value((int)this.m_Instances.instance(i).value(j)), (String)outatt.value((int)result.instance(i).value(j)));
            }
        }
    }

    public void testMeansAndModes() {
        this.m_Filter = new MissingValuesImputation();
        ((MissingValuesImputation)this.m_Filter).setAlgorithm((Imputation)new MeansAndModes());
        Instances result = this.useFilter();
        MissingValuesImputationTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MissingValuesImputationTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        for (int j = 0; j < this.m_Instances.numAttributes(); ++j) {
            Attribute inatt = this.m_Instances.attribute(j);
            Attribute outatt = result.attribute(j);
            for (int i = 0; i < this.m_Instances.numInstances(); ++i) {
                if (this.m_Instances.attribute(j).isString()) {
                    if (this.m_Instances.instance(i).isMissing(j)) {
                        MissingValuesImputationTest.assertTrue((String)"Missing values in strings cannot be replaced", (boolean)result.instance(i).isMissing(j));
                        continue;
                    }
                    MissingValuesImputationTest.assertEquals((String)"String values should not have changed", (String)inatt.value((int)this.m_Instances.instance(i).value(j)), (String)outatt.value((int)result.instance(i).value(j)));
                    continue;
                }
                MissingValuesImputationTest.assertTrue((String)"All non-string missing values should have been replaced", (!result.instance(i).isMissing(j) ? 1 : 0) != 0);
            }
        }
    }

    public static Test suite() {
        return new TestSuite(MissingValuesImputationTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MissingValuesImputationTest.suite());
    }
}

