/*
 * Decompiled with CFR 0.152.
 */
package weka.core.code;

import weka.core.code.Instantiation;

public class InstantiationWithTryCatch
extends Instantiation {
    private static final long serialVersionUID = -404041602856749882L;

    @Override
    public String getName() {
        return super.getName() + " (with TryCatch)";
    }

    @Override
    protected String convert(String cmd, boolean quiet) {
        String result = super.convert(cmd, quiet);
        if (result != null) {
            String[] lines = result.split("\n");
            StringBuilder full = new StringBuilder();
            full.append(lines[0]);
            full.append("\n");
            full.append("try {\n");
            for (int i = 1; i < lines.length; ++i) {
                full.append("  ");
                full.append(lines[i]);
                full.append("\n");
            }
            full.append("} catch (Exception e) {\n");
            full.append("  System.err.println(\"Failed to instantiate!\");\n");
            full.append("  e.printStackTrace();\n");
            full.append("}");
            result = full.toString();
        }
        return result;
    }
}

