/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import weka.core.code.AbstractConverter;
import weka.core.code.Converter;
import weka.gui.ComponentHelper;

public class CommandToCodePanel
extends JPanel {
    protected Converter[] m_Converters;
    protected JButton m_ButtonPaste;
    protected JButton m_ButtonCopy;
    protected JPanel m_PanelCommand;
    protected JPanel m_PanelCode;
    protected JTextArea m_TextCommand;
    protected JTextArea m_TextCode;
    protected JLabel m_LabelCommand;
    protected JLabel m_LabelCode;
    protected JLabel m_LabelConverters;
    protected JComboBox m_ComboBoxConverters;
    protected JButton m_ButtonConverters;

    public CommandToCodePanel() {
        this.initialize();
        this.initGUI();
        this.finishInit();
    }

    protected void initialize() {
        this.m_Converters = AbstractConverter.getConverters();
    }

    protected void initGUI() {
        this.setLayout(new GridLayout(2, 1));
        this.m_PanelCommand = new JPanel(new BorderLayout());
        this.m_PanelCommand.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(this.m_PanelCommand);
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        this.m_PanelCommand.add(panel);
        this.m_LabelCommand = new JLabel("Command-line");
        this.m_TextCommand = new JTextArea();
        this.m_TextCommand.setFont(new Font("monospaced", 0, 12));
        JPanel panel2 = new JPanel(new FlowLayout(0, 0, 0));
        panel.add((Component)panel2, "North");
        panel2.add(this.m_LabelCommand);
        panel.add((Component)new JScrollPane(this.m_TextCommand), "Center");
        panel2 = new JPanel(new BorderLayout());
        panel.add((Component)panel2, "East");
        this.m_ButtonPaste = new JButton(ComponentHelper.getImageIcon((String)"weka/gui/images/paste.gif"));
        this.m_ButtonPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = CommandToCodePanel.this.pasteStringFromClipboard();
                if (s != null) {
                    CommandToCodePanel.this.m_TextCommand.setText(s);
                }
            }
        });
        panel2.add((Component)this.m_ButtonPaste, "North");
        this.m_ComboBoxConverters = new JComboBox<Converter>(this.m_Converters);
        this.m_LabelConverters = new JLabel("Converter");
        this.m_LabelConverters.setLabelFor(this.m_ComboBoxConverters);
        this.m_ButtonConverters = new JButton("Execute");
        this.m_ButtonConverters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandToCodePanel.this.convert();
            }
        });
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.m_LabelConverters);
        panel.add(this.m_ComboBoxConverters);
        panel.add(this.m_ButtonConverters);
        this.m_PanelCommand.add((Component)panel, "South");
        this.m_PanelCode = new JPanel(new BorderLayout());
        this.m_PanelCode.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(this.m_PanelCode);
        panel = new JPanel(new BorderLayout(0, 0));
        this.m_PanelCode.add(panel);
        this.m_LabelCode = new JLabel("Generated code");
        this.m_TextCode = new JTextArea();
        this.m_TextCode.setFont(new Font("monospaced", 0, 12));
        this.m_TextCode.setEditable(false);
        panel2 = new JPanel(new FlowLayout(0, 0, 0));
        panel.add((Component)panel2, "North");
        panel2.add(this.m_LabelCode);
        panel.add((Component)new JScrollPane(this.m_TextCode), "Center");
        panel2 = new JPanel(new BorderLayout());
        panel.add((Component)panel2, "East");
        this.m_ButtonCopy = new JButton(ComponentHelper.getImageIcon((String)"weka/gui/images/copy.gif"));
        this.m_ButtonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CommandToCodePanel.this.m_TextCode.getText().length() > 0) {
                    CommandToCodePanel.this.copyToClipboard(CommandToCodePanel.this.m_TextCode.getText());
                }
            }
        });
        panel2.add((Component)this.m_ButtonCopy, "North");
    }

    protected void finishInit() {
        this.m_ComboBoxConverters.setSelectedIndex(0);
        this.m_TextCommand.setText("");
        this.m_TextCode.setText("");
    }

    protected void convert() {
        String cmd = this.m_TextCommand.getText();
        if (cmd.trim().length() == 0) {
            ComponentHelper.showMessageBox((Component)this, (String)"Error", (String)"No command line to convert!", (int)2, (int)0);
            return;
        }
        Converter conv = (Converter)this.m_ComboBoxConverters.getSelectedItem();
        if (!conv.handles(cmd)) {
            ComponentHelper.showMessageBox((Component)this, (String)"Error", (String)("Command-line cannot be processed by the '" + conv.getName() + "' converter!"), (int)2, (int)0);
            return;
        }
        this.m_TextCode.setText(conv.convert(cmd));
    }

    protected String pasteStringFromClipboard() {
        String result = null;
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable content = clipboard.getContents(null);
            if (content != null && content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                result = (String)content.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    protected void copyToClipboard(String s) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new TransferableString(s), null);
    }

    public static void main(String[] args) {
        CommandToCodePanel panel = new CommandToCodePanel();
        JFrame frame = new JFrame("Command to code");
        frame.setDefaultCloseOperation(3);
        frame.setIconImage(ComponentHelper.getImage((String)"weka/gui/weka_icon_new_small.png"));
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)panel, "Center");
        frame.setSize(600, 400);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static class TransferableString
    implements Serializable,
    Transferable {
        private static final long serialVersionUID = -4291529156857201031L;
        protected String m_Data;

        public TransferableString(String data) {
            this.m_Data = data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(DataFlavor.stringFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.stringFlavor)) {
                return this.m_Data;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        public String getData() {
            return this.m_Data;
        }

        public String toString() {
            return this.m_Data;
        }
    }
}

