/*
 * Decompiled with CFR 0.152.
 */
package weka.core.code;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import weka.core.ClassDiscovery;
import weka.core.code.Converter;

public abstract class AbstractConverter
implements Converter {
    @Override
    public int compareTo(Converter o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return this.getName();
    }

    public static Converter[] getConverters() {
        ArrayList<Converter> result = new ArrayList<Converter>();
        Vector classes = ClassDiscovery.find(Converter.class, (String)Converter.class.getPackage().getName());
        for (String cls : classes) {
            try {
                Converter conv = (Converter)Class.forName(cls).newInstance();
                result.add(conv);
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate: " + cls);
                e.printStackTrace();
            }
        }
        Collections.sort(result);
        return result.toArray(new Converter[result.size()]);
    }
}

