/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.postprocess.provided;

import com.github.fonimus.ssh.shell.postprocess.PostProcessor;
import com.github.fonimus.ssh.shell.postprocess.PostProcessorException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavePostProcessor
implements PostProcessor<Object, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SavePostProcessor.class);
    public static final String SAVE = "save";
    private static final String REPLACE_REGEX = "(\\x1b\\x5b|\\x9b)[\\x30-\\x3f]*[\\x20-\\x2f]*[\\x40-\\x7e]";

    @Override
    public String getName() {
        return SAVE;
    }

    @Override
    public String process(Object result, List<String> parameters) throws PostProcessorException {
        String path;
        if (parameters == null || parameters.isEmpty()) {
            throw new PostProcessorException("Cannot save without file path !");
        }
        if (parameters.size() != 1) {
            LOGGER.debug("[{}] post processor only need one parameter, rest will be ignored", (Object)this.getName());
        }
        if ((path = parameters.get(0)) == null || path.isEmpty()) {
            throw new PostProcessorException("Cannot save without file path !");
        }
        File file = new File(path);
        try {
            String toWrite = this.string(result).replaceAll(REPLACE_REGEX, "") + "\n";
            Files.write(file.toPath(), toWrite.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            return "Result saved to file: " + file.getAbsolutePath();
        }
        catch (IOException e) {
            LOGGER.debug("Unable to write to file: " + file.getAbsolutePath(), (Throwable)e);
            throw new PostProcessorException("Unable to write to file: " + file.getAbsolutePath() + ". " + e.getMessage(), e);
        }
    }

    private String string(Object result) {
        if (result instanceof String) {
            return (String)result;
        }
        if (result instanceof Throwable) {
            return ((Throwable)result).getClass().getName() + ": " + ((Throwable)result).getMessage();
        }
        if (result != null) {
            return result.toString();
        }
        return "";
    }
}

