/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.postprocess.provided;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fonimus.ssh.shell.postprocess.PostProcessor;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPointerPostProcessor
implements PostProcessor<String, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPointerPostProcessor.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public String getName() {
        return "json";
    }

    @Override
    public String process(String result, List<String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            LOGGER.debug("Cannot use [{}] post processor without any parameters", (Object)this.getName());
        } else {
            if (parameters.size() != 1) {
                LOGGER.debug("[{}] post processor only need one parameter, rest will be ignored", (Object)this.getName());
            }
            String path = parameters.get(0);
            try {
                JsonNode node = MAPPER.readTree(result).at(path);
                if (node.isMissingNode()) {
                    return "No node found with json path expression: " + path;
                }
                if (node.isTextual()) {
                    return node.asText();
                }
                return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to read tree", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Illegal argument: " + path, (Throwable)e);
                return e.getMessage();
            }
        }
        return result;
    }
}

