/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.commands.actuator;

import com.github.fonimus.ssh.shell.SshShellHelper;
import com.github.fonimus.ssh.shell.SshShellProperties;
import com.github.fonimus.ssh.shell.commands.AbstractCommand;
import com.github.fonimus.ssh.shell.commands.SshShellComponent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.actuate.audit.AuditEventsEndpoint;
import org.springframework.boot.actuate.autoconfigure.condition.ConditionsReportEndpoint;
import org.springframework.boot.actuate.beans.BeansEndpoint;
import org.springframework.boot.actuate.context.ShutdownEndpoint;
import org.springframework.boot.actuate.context.properties.ConfigurationPropertiesReportEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.env.EnvironmentEndpoint;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.info.InfoEndpoint;
import org.springframework.boot.actuate.logging.LoggersEndpoint;
import org.springframework.boot.actuate.management.ThreadDumpEndpoint;
import org.springframework.boot.actuate.metrics.MetricsEndpoint;
import org.springframework.boot.actuate.scheduling.ScheduledTasksEndpoint;
import org.springframework.boot.actuate.session.SessionsEndpoint;
import org.springframework.boot.actuate.trace.http.HttpTraceEndpoint;
import org.springframework.boot.actuate.web.mappings.MappingsEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.logging.LogLevel;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.shell.Availability;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;
import org.springframework.shell.standard.ShellOption;

@SshShellComponent
@ShellCommandGroup(value="Actuator Commands")
@ConditionalOnClass(value={Endpoint.class})
@ConditionalOnProperty(name={"ssh.shell.commands.actuator.create"}, havingValue="true", matchIfMissing=true)
public class ActuatorCommand
extends AbstractCommand {
    public static final String GROUP = "actuator";
    private static final Logger LOGGER = LoggerFactory.getLogger(ActuatorCommand.class);
    private final ApplicationContext applicationContext;
    private final Environment environment;
    private final AuditEventsEndpoint audit;
    private final BeansEndpoint beans;
    private final ConditionsReportEndpoint conditions;
    private final ConfigurationPropertiesReportEndpoint configprops;
    private final EnvironmentEndpoint env;
    private final HealthEndpoint health;
    private final HttpTraceEndpoint httptrace;
    private final InfoEndpoint info;
    private final LoggersEndpoint loggers;
    private final MetricsEndpoint metrics;
    private final MappingsEndpoint mappings;
    private final ScheduledTasksEndpoint scheduledtasks;
    private final ShutdownEndpoint shutdown;
    private final ThreadDumpEndpoint threaddump;

    public ActuatorCommand(ApplicationContext applicationContext, Environment environment, SshShellProperties properties, SshShellHelper helper, @Lazy AuditEventsEndpoint audit, @Lazy BeansEndpoint beans, @Lazy ConditionsReportEndpoint conditions, @Lazy ConfigurationPropertiesReportEndpoint configprops, @Lazy EnvironmentEndpoint env, @Lazy HealthEndpoint health, @Lazy HttpTraceEndpoint httptrace, @Lazy InfoEndpoint info, @Lazy LoggersEndpoint loggers, @Lazy MetricsEndpoint metrics, @Lazy MappingsEndpoint mappings, @Lazy ScheduledTasksEndpoint scheduledtasks, @Lazy ShutdownEndpoint shutdown, @Lazy ThreadDumpEndpoint threaddump) {
        super(helper, properties, properties.getCommands().getActuator());
        this.applicationContext = applicationContext;
        this.environment = environment;
        this.audit = audit;
        this.beans = beans;
        this.conditions = conditions;
        this.configprops = configprops;
        this.env = env;
        this.health = health;
        this.httptrace = httptrace;
        this.info = info;
        this.loggers = loggers;
        this.metrics = metrics;
        this.mappings = mappings;
        this.scheduledtasks = scheduledtasks;
        this.shutdown = shutdown;
        this.threaddump = threaddump;
    }

    @ShellMethod(key={"audit"}, value="Display audit endpoint.")
    @ShellMethodAvailability(value={"auditAvailability"})
    public AuditEventsEndpoint.AuditEventsDescriptor audit(@ShellOption(value={"-p", "--principal"}, defaultValue="__NULL__", help="Principal to filter on") String principal, @ShellOption(value={"-t", "--type"}, defaultValue="__NULL__", help="Type to filter on") String type) {
        return this.audit.events(principal, null, type);
    }

    public Availability auditAvailability() {
        return this.availability("audit", AuditEventsEndpoint.class);
    }

    @ShellMethod(key={"beans"}, value="Display beans endpoint.")
    @ShellMethodAvailability(value={"beansAvailability"})
    public BeansEndpoint.ApplicationBeans beans() {
        return this.beans.beans();
    }

    public Availability beansAvailability() {
        return this.availability("beans", BeansEndpoint.class);
    }

    @ShellMethod(key={"conditions"}, value="Display conditions endpoint.")
    @ShellMethodAvailability(value={"conditionsAvailability"})
    public ConditionsReportEndpoint.ApplicationConditionEvaluation conditions() {
        return this.conditions.applicationConditionEvaluation();
    }

    public Availability conditionsAvailability() {
        return this.availability("conditions", ConditionsReportEndpoint.class);
    }

    @ShellMethod(key={"configprops"}, value="Display configprops endpoint.")
    @ShellMethodAvailability(value={"configpropsAvailability"})
    public ConfigurationPropertiesReportEndpoint.ApplicationConfigurationProperties configprops() {
        return this.configprops.configurationProperties();
    }

    public Availability configpropsAvailability() {
        return this.availability("configprops", ConfigurationPropertiesReportEndpoint.class);
    }

    @ShellMethod(key={"env"}, value="Display env endpoint.")
    @ShellMethodAvailability(value={"envAvailability"})
    public EnvironmentEndpoint.EnvironmentDescriptor env(@ShellOption(value={"-p", "--pattern"}, defaultValue="__NULL__", help="Pattern to filter on") String pattern) {
        return this.env.environment(pattern);
    }

    public Availability envAvailability() {
        return this.availability("env", EnvironmentEndpoint.class);
    }

    @ShellMethod(key={"health"}, value="Display health endpoint.")
    @ShellMethodAvailability(value={"healthAvailability"})
    public Object health(@ShellOption(value={"-p", "--path"}, defaultValue="__NULL__", help="Path to query health (component namen, group name)") String path) {
        try {
            if (path != null) {
                return this.health.healthForPath(new String[]{path});
            }
            return this.health.health();
        }
        catch (NoSuchMethodError e) {
            try {
                Method method = this.health.getClass().getMethod("health", new Class[0]);
                return method.invoke((Object)this.health, new Object[0]);
            }
            catch (NoSuchMethodException ex) {
                LOGGER.debug("Unable to get method: health from HealthEndpoint class: {}", (Object)this.health.getClass().getName(), (Object)ex);
                throw e;
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                LOGGER.trace("Unable to invoke method: health from HealthEndpoint class: {}", (Object)this.health.getClass().getName(), (Object)ex);
                throw e;
            }
        }
    }

    public Availability healthAvailability() {
        return this.availability("health", HealthEndpoint.class);
    }

    @ShellMethod(key={"httptrace"}, value="Display httptrace endpoint.")
    @ShellMethodAvailability(value={"httptraceAvailability"})
    public HttpTraceEndpoint.HttpTraceDescriptor httptrace() {
        return this.httptrace.traces();
    }

    public Availability httptraceAvailability() {
        return this.availability("httptrace", HttpTraceEndpoint.class);
    }

    @ShellMethod(key={"info"}, value="Display info endpoint.")
    @ShellMethodAvailability(value={"infoAvailability"})
    public Map<String, Object> info() {
        return this.info.info();
    }

    public Availability infoAvailability() {
        return this.availability("info", InfoEndpoint.class);
    }

    @ShellMethod(key={"loggers"}, value="Display or configure loggers.")
    @ShellMethodAvailability(value={"loggersAvailability"})
    public Object loggers(@ShellOption(value={"-a", "--action"}, help="Action to perform", defaultValue="list") LoggerAction action, @ShellOption(value={"-n", "--name"}, help="Logger name for configuration or display", defaultValue="__NULL__") String loggerName, @ShellOption(value={"-l", "--level"}, help="Logger level for configuration", defaultValue="__NULL__") LogLevel loggerLevel) {
        if ((action == LoggerAction.get || action == LoggerAction.conf) && loggerName == null) {
            throw new IllegalArgumentException("Logger name is mandatory for '" + (Object)((Object)action) + "' action");
        }
        switch (action) {
            case get: {
                LoggersEndpoint.LoggerLevels levels = this.loggers.loggerLevels(loggerName);
                return "Logger named [" + loggerName + "] : [configured: " + levels.getConfiguredLevel() + "]";
            }
            case conf: {
                if (loggerLevel == null) {
                    throw new IllegalArgumentException("Logger level is mandatory for '" + (Object)((Object)action) + "' action");
                }
                this.loggers.configureLogLevel(loggerName, loggerLevel);
                return "Logger named [" + loggerName + "] now configured to level [" + loggerLevel + "]";
            }
        }
        return this.loggers.loggers();
    }

    public Availability loggersAvailability() {
        return this.availability("loggers", LoggersEndpoint.class);
    }

    @ShellMethod(key={"metrics"}, value="Display metrics endpoint.")
    @ShellMethodAvailability(value={"metricsAvailability"})
    public Object metrics(@ShellOption(value={"-n", "--name"}, help="Metric name to get", defaultValue="__NULL__") String name, @ShellOption(value={"-t", "--tags"}, help="Tags (key=value, separated by coma)", defaultValue="__NULL__") String tags) {
        if (name != null) {
            MetricsEndpoint.MetricResponse result = this.metrics.metric(name, tags != null ? Arrays.asList(tags.split(",")) : null);
            if (result == null) {
                String tagsStr = tags != null ? " and tags: " + tags : "";
                throw new IllegalArgumentException("No result for metrics name: " + name + tagsStr);
            }
            return result;
        }
        return this.metrics.listNames();
    }

    public Availability metricsAvailability() {
        return this.availability("metrics", MetricsEndpoint.class);
    }

    @ShellMethod(key={"mappings"}, value="Display mappings endpoint.")
    @ShellMethodAvailability(value={"mappingsAvailability"})
    public MappingsEndpoint.ApplicationMappings mappings() {
        return this.mappings.mappings();
    }

    public Availability mappingsAvailability() {
        return this.availability("mappings", MappingsEndpoint.class);
    }

    @ShellMethod(key={"sessions"}, value="Display sessions endpoint.")
    @ShellMethodAvailability(value={"sessionsAvailability"})
    public SessionsEndpoint.SessionsReport sessions() {
        return ((SessionsEndpoint)this.applicationContext.getBean(SessionsEndpoint.class)).sessionsForUsername(null);
    }

    public Availability sessionsAvailability() {
        return this.availability("sessions", SessionsEndpoint.class);
    }

    @ShellMethod(key={"scheduledtasks"}, value="Display scheduledtasks endpoint.")
    @ShellMethodAvailability(value={"scheduledtasksAvailability"})
    public ScheduledTasksEndpoint.ScheduledTasksReport scheduledtasks() {
        return this.scheduledtasks.scheduledTasks();
    }

    public Availability scheduledtasksAvailability() {
        return this.availability("scheduledtasks", ScheduledTasksEndpoint.class);
    }

    @ShellMethod(key={"shutdown"}, value="Shutdown application.")
    @ShellMethodAvailability(value={"shutdownAvailability"})
    public String shutdown() {
        if (this.helper.confirm("Are you sure you want to shutdown application ? [y/N]", new String[0])) {
            this.helper.print("Shutting down application...");
            this.shutdown.shutdown();
            return "";
        }
        return "Aborting shutdown";
    }

    public Availability shutdownAvailability() {
        return this.availability("shutdown", ShutdownEndpoint.class, false);
    }

    @ShellMethod(key={"threaddump"}, value="Display threaddump endpoint.")
    @ShellMethodAvailability(value={"threaddumpAvailability"})
    public ThreadDumpEndpoint.ThreadDumpDescriptor threaddump() {
        return this.threaddump.threadDump();
    }

    public Availability threaddumpAvailability() {
        return this.availability("threaddump", ThreadDumpEndpoint.class);
    }

    private Availability availability(String name, Class<?> clazz) {
        return this.availability(name, clazz, true);
    }

    private Availability availability(String name, Class<?> clazz, boolean defaultValue) {
        boolean forbidden;
        Availability av = this.availability(GROUP, name);
        boolean bl = forbidden = av.getReason() != null && av.getReason().contains("forbidden");
        if (!(av.isAvailable() || forbidden && "info".equals(name))) {
            return av;
        }
        String property = "management.endpoint." + name + ".enabled";
        if (!((Boolean)this.environment.getProperty(property, Boolean.TYPE, (Object)defaultValue)).booleanValue()) {
            return Availability.unavailable((String)("endpoint '" + name + "' deactivated (please check property '" + property + "')"));
        }
        try {
            this.applicationContext.getBean(clazz);
        }
        catch (NoSuchBeanDefinitionException e) {
            return Availability.unavailable((String)(clazz.getName() + " is not in application context"));
        }
        return Availability.available();
    }

    public static enum LoggerAction {
        list,
        get,
        conf;

    }
}

