/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.commands;

import com.github.fonimus.ssh.shell.SshShellHelper;
import com.github.fonimus.ssh.shell.SshShellProperties;
import com.github.fonimus.ssh.shell.commands.AbstractCommand;
import com.github.fonimus.ssh.shell.commands.SshShellComponent;
import com.github.fonimus.ssh.shell.postprocess.PostProcessor;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.shell.Availability;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;

@SshShellComponent
@ShellCommandGroup(value="Built-In Commands")
@ConditionalOnProperty(name={"ssh.shell.commands.postprocessors.create"}, havingValue="true", matchIfMissing=true)
public class PostProcessorsCommand
extends AbstractCommand {
    public static final String GROUP = "postprocessors";
    public static final String COMMAND_POST_PROCESSORS = "postprocessors";
    private final List<PostProcessor<?, ?>> postProcessors;

    public PostProcessorsCommand(SshShellHelper helper, SshShellProperties properties, List<PostProcessor<?, ?>> postProcessors) {
        super(helper, properties, properties.getCommands().getPostprocessors());
        this.postProcessors = new ArrayList(postProcessors);
        this.postProcessors.sort(Comparator.comparing(PostProcessor::getName));
    }

    @ShellMethod(key={"postprocessors"}, value="Display the available post processors")
    @ShellMethodAvailability(value={"postprocessorsAvailability"})
    public CharSequence postprocessors() {
        AttributedStringBuilder result = new AttributedStringBuilder();
        result.append((CharSequence)"Available Post-Processors\n\n", AttributedStyle.BOLD);
        for (PostProcessor<?, ?> postProcessor : this.postProcessors) {
            result.append((CharSequence)("\t" + postProcessor.getName() + ":\n"), AttributedStyle.BOLD);
            Class input = (Class)((ParameterizedType)postProcessor.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
            Class output = (Class)((ParameterizedType)postProcessor.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[1];
            result.append((CharSequence)("\t\tinput  : " + input.getName() + "\n"), AttributedStyle.DEFAULT);
            result.append((CharSequence)("\t\toutput : " + output.getName() + "\n"), AttributedStyle.DEFAULT);
        }
        return result;
    }

    private Availability postprocessorsAvailability() {
        return this.availability("postprocessors", "postprocessors");
    }
}

