/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.commands;

import com.github.fonimus.ssh.shell.SshShellHelper;
import com.github.fonimus.ssh.shell.SshShellProperties;
import com.github.fonimus.ssh.shell.commands.SshShellComponent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;
import org.springframework.shell.standard.commands.History;

@SshShellComponent
@ShellCommandGroup(value="Built-In Commands")
public class HistoryCommand
implements History.Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(HistoryCommand.class);
    private SshShellProperties properties;
    private SshShellHelper helper;
    private org.jline.reader.History history;

    public HistoryCommand(SshShellProperties properties, SshShellHelper helper, @Lazy org.jline.reader.History history) {
        this.properties = properties;
        this.helper = helper;
        this.history = history;
    }

    @ShellMethod(value="Display or save the history of previously run commands")
    public List<String> history(@ShellOption(help="A file to save history to.", defaultValue="__NULL__") File file) throws IOException {
        org.jline.reader.History historyToUse = this.history;
        if (!this.properties.isSharedHistory() && !this.helper.isLocalPrompt()) {
            LOGGER.debug("History is not shared and this is not from local prompt, getting specific user history");
            historyToUse = this.helper.getHistory();
        }
        return new History(historyToUse).history(file);
    }
}

