/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.commands;

import java.util.Arrays;
import java.util.List;

public class CommandProperties {
    private boolean create = true;
    private boolean enable = true;
    private boolean restricted = true;
    private List<String> authorizedRoles = Arrays.asList("ADMIN");
    private List<String> includes;
    private List<String> excludes;

    public static CommandProperties disabledByDefault() {
        CommandProperties properties = new CommandProperties();
        properties.setEnable(false);
        return properties;
    }

    public static CommandProperties withAuthorizedRoles(List<String> authorizedRoles) {
        CommandProperties properties = new CommandProperties();
        properties.setAuthorizedRoles(authorizedRoles);
        return properties;
    }

    public static CommandProperties notRestrictedByDefault() {
        CommandProperties properties = new CommandProperties();
        properties.setRestricted(false);
        properties.setAuthorizedRoles(null);
        return properties;
    }

    public static CommandProperties withExcludedByDefault(List<String> excludes) {
        CommandProperties properties = new CommandProperties();
        properties.setExcludes(excludes);
        return properties;
    }

    public boolean isCreate() {
        return this.create;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public List<String> getAuthorizedRoles() {
        return this.authorizedRoles;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    public void setAuthorizedRoles(List<String> authorizedRoles) {
        this.authorizedRoles = authorizedRoles;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandProperties)) {
            return false;
        }
        CommandProperties other = (CommandProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCreate() != other.isCreate()) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (this.isRestricted() != other.isRestricted()) {
            return false;
        }
        List<String> this$authorizedRoles = this.getAuthorizedRoles();
        List<String> other$authorizedRoles = other.getAuthorizedRoles();
        if (this$authorizedRoles == null ? other$authorizedRoles != null : !((Object)this$authorizedRoles).equals(other$authorizedRoles)) {
            return false;
        }
        List<String> this$includes = this.getIncludes();
        List<String> other$includes = other.getIncludes();
        if (this$includes == null ? other$includes != null : !((Object)this$includes).equals(other$includes)) {
            return false;
        }
        List<String> this$excludes = this.getExcludes();
        List<String> other$excludes = other.getExcludes();
        return !(this$excludes == null ? other$excludes != null : !((Object)this$excludes).equals(other$excludes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommandProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCreate() ? 79 : 97);
        result = result * 59 + (this.isEnable() ? 79 : 97);
        result = result * 59 + (this.isRestricted() ? 79 : 97);
        List<String> $authorizedRoles = this.getAuthorizedRoles();
        result = result * 59 + ($authorizedRoles == null ? 43 : ((Object)$authorizedRoles).hashCode());
        List<String> $includes = this.getIncludes();
        result = result * 59 + ($includes == null ? 43 : ((Object)$includes).hashCode());
        List<String> $excludes = this.getExcludes();
        result = result * 59 + ($excludes == null ? 43 : ((Object)$excludes).hashCode());
        return result;
    }

    public String toString() {
        return "CommandProperties(create=" + this.isCreate() + ", enable=" + this.isEnable() + ", restricted=" + this.isRestricted() + ", authorizedRoles=" + this.getAuthorizedRoles() + ", includes=" + this.getIncludes() + ", excludes=" + this.getExcludes() + ")";
    }

    public CommandProperties() {
    }

    public CommandProperties(boolean create, boolean enable, boolean restricted, List<String> authorizedRoles, List<String> includes, List<String> excludes) {
        this.create = create;
        this.enable = enable;
        this.restricted = restricted;
        this.authorizedRoles = authorizedRoles;
        this.includes = includes;
        this.excludes = excludes;
    }
}

