/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell;

import java.util.Map;
import org.apache.sshd.common.channel.PtyMode;
import org.jline.terminal.Attributes;

public final class SshShellUtils {
    private SshShellUtils() {
    }

    public static void fill(Attributes attr, Map<PtyMode, Integer> ptyModes) {
        for (Map.Entry<PtyMode, Integer> e : ptyModes.entrySet()) {
            switch (e.getKey()) {
                case VINTR: {
                    attr.setControlChar(Attributes.ControlChar.VINTR, e.getValue().intValue());
                    break;
                }
                case VQUIT: {
                    attr.setControlChar(Attributes.ControlChar.VQUIT, e.getValue().intValue());
                    break;
                }
                case VERASE: {
                    attr.setControlChar(Attributes.ControlChar.VERASE, e.getValue().intValue());
                    break;
                }
                case VKILL: {
                    attr.setControlChar(Attributes.ControlChar.VKILL, e.getValue().intValue());
                    break;
                }
                case VEOF: {
                    attr.setControlChar(Attributes.ControlChar.VEOF, e.getValue().intValue());
                    break;
                }
                case VEOL: {
                    attr.setControlChar(Attributes.ControlChar.VEOL, e.getValue().intValue());
                    break;
                }
                case VEOL2: {
                    attr.setControlChar(Attributes.ControlChar.VEOL2, e.getValue().intValue());
                    break;
                }
                case VSTART: {
                    attr.setControlChar(Attributes.ControlChar.VSTART, e.getValue().intValue());
                    break;
                }
                case VSTOP: {
                    attr.setControlChar(Attributes.ControlChar.VSTOP, e.getValue().intValue());
                    break;
                }
                case VSUSP: {
                    attr.setControlChar(Attributes.ControlChar.VSUSP, e.getValue().intValue());
                    break;
                }
                case VDSUSP: {
                    attr.setControlChar(Attributes.ControlChar.VDSUSP, e.getValue().intValue());
                    break;
                }
                case VREPRINT: {
                    attr.setControlChar(Attributes.ControlChar.VREPRINT, e.getValue().intValue());
                    break;
                }
                case VWERASE: {
                    attr.setControlChar(Attributes.ControlChar.VWERASE, e.getValue().intValue());
                    break;
                }
                case VLNEXT: {
                    attr.setControlChar(Attributes.ControlChar.VLNEXT, e.getValue().intValue());
                    break;
                }
                case VSTATUS: {
                    attr.setControlChar(Attributes.ControlChar.VSTATUS, e.getValue().intValue());
                    break;
                }
                case VDISCARD: {
                    attr.setControlChar(Attributes.ControlChar.VDISCARD, e.getValue().intValue());
                    break;
                }
                case ECHO: {
                    attr.setLocalFlag(Attributes.LocalFlag.ECHO, e.getValue() != 0);
                    break;
                }
                case ICANON: {
                    attr.setLocalFlag(Attributes.LocalFlag.ICANON, e.getValue() != 0);
                    break;
                }
                case ISIG: {
                    attr.setLocalFlag(Attributes.LocalFlag.ISIG, e.getValue() != 0);
                    break;
                }
                case ICRNL: {
                    attr.setInputFlag(Attributes.InputFlag.ICRNL, e.getValue() != 0);
                    break;
                }
                case INLCR: {
                    attr.setInputFlag(Attributes.InputFlag.INLCR, e.getValue() != 0);
                    break;
                }
                case IGNCR: {
                    attr.setInputFlag(Attributes.InputFlag.IGNCR, e.getValue() != 0);
                    break;
                }
                case OCRNL: {
                    attr.setOutputFlag(Attributes.OutputFlag.OCRNL, e.getValue() != 0);
                    break;
                }
                case ONLCR: {
                    attr.setOutputFlag(Attributes.OutputFlag.ONLCR, e.getValue() != 0);
                    break;
                }
                case ONLRET: {
                    attr.setOutputFlag(Attributes.OutputFlag.ONLRET, e.getValue() != 0);
                    break;
                }
                case OPOST: {
                    attr.setOutputFlag(Attributes.OutputFlag.OPOST, e.getValue() != 0);
                    break;
                }
            }
        }
    }
}

