/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell;

import com.github.fonimus.ssh.shell.ExtendedCompletionProposal;
import java.util.List;
import java.util.stream.Collectors;
import org.jline.reader.Candidate;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.springframework.shell.CompletingParsedLine;
import org.springframework.shell.CompletionContext;
import org.springframework.shell.CompletionProposal;
import org.springframework.shell.Shell;
import org.springframework.shell.jline.JLineShellAutoConfiguration;

public class ExtendedCompleterAdapter
extends JLineShellAutoConfiguration.CompleterAdapter {
    private final Shell shell;

    public ExtendedCompleterAdapter(Shell shell) {
        this.shell = shell;
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        CompletingParsedLine cpl = line instanceof CompletingParsedLine ? (CompletingParsedLine)line : t -> t;
        CompletionContext context = new CompletionContext(ExtendedCompleterAdapter.sanitizeInput(line.words()), line.wordIndex(), line.wordCursor());
        this.shell.complete(context).stream().map(p -> new Candidate(p.dontQuote() ? p.value() : cpl.emit((CharSequence)p.value()).toString(), p.displayText(), p.category(), p.description(), null, null, ExtendedCompleterAdapter.isComplete(p))).forEach(candidates::add);
    }

    private static boolean isComplete(CompletionProposal p) {
        if (p instanceof ExtendedCompletionProposal) {
            return ((ExtendedCompletionProposal)p).isComplete();
        }
        return true;
    }

    private static List<String> sanitizeInput(List<String> words) {
        return words.stream().map(s -> s.replaceAll("^\\n+|\\n+$", "")).map(s -> s.replaceAll("\\n+", " ")).collect(Collectors.toList());
    }
}

