/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.postprocess.provided;

import com.github.fonimus.ssh.shell.PromptColor;
import com.github.fonimus.ssh.shell.SshShellHelper;
import com.github.fonimus.ssh.shell.postprocess.PostProcessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighlightPostProcessor
implements PostProcessor<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HighlightPostProcessor.class);

    @Override
    public String getName() {
        return "highlight";
    }

    @Override
    public String process(String result, List<String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            LOGGER.debug("Cannot use [{}] post processor without any parameters", (Object)this.getName());
            return result;
        }
        String finalResult = result;
        for (String toHighlight : parameters) {
            finalResult = finalResult.replaceAll(toHighlight, SshShellHelper.getBackgroundColoredMessage(toHighlight, PromptColor.YELLOW));
        }
        return finalResult;
    }
}

