/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.interactive;

import com.github.fonimus.ssh.shell.interactive.KeyBindingInput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class KeyBinding {
    @NonNull
    private String description;
    @NonNull
    private KeyBindingInput input;
    @NonNull
    private List<String> keys;

    KeyBinding(@NonNull String description, @NonNull KeyBindingInput input, @NonNull List<String> keys) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        this.description = description;
        this.input = input;
        this.keys = keys;
    }

    public static KeyBindingBuilder builder() {
        return new KeyBindingBuilder();
    }

    @NonNull
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public KeyBindingInput getInput() {
        return this.input;
    }

    @NonNull
    public List<String> getKeys() {
        return this.keys;
    }

    public static class KeyBindingBuilder {
        private String description;
        private KeyBindingInput input;
        private ArrayList<String> keys;

        KeyBindingBuilder() {
        }

        public KeyBindingBuilder description(@NonNull String description) {
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            this.description = description;
            return this;
        }

        public KeyBindingBuilder input(@NonNull KeyBindingInput input) {
            if (input == null) {
                throw new NullPointerException("input is marked non-null but is null");
            }
            this.input = input;
            return this;
        }

        public KeyBindingBuilder key(String key) {
            if (this.keys == null) {
                this.keys = new ArrayList();
            }
            this.keys.add(key);
            return this;
        }

        public KeyBindingBuilder keys(Collection<? extends String> keys) {
            if (keys == null) {
                throw new NullPointerException("keys cannot be null");
            }
            if (this.keys == null) {
                this.keys = new ArrayList();
            }
            this.keys.addAll(keys);
            return this;
        }

        public KeyBindingBuilder clearKeys() {
            if (this.keys != null) {
                this.keys.clear();
            }
            return this;
        }

        public KeyBinding build() {
            List<String> keys;
            switch (this.keys == null ? 0 : this.keys.size()) {
                case 0: {
                    keys = Collections.emptyList();
                    break;
                }
                case 1: {
                    keys = Collections.singletonList(this.keys.get(0));
                    break;
                }
                default: {
                    keys = Collections.unmodifiableList(new ArrayList<String>(this.keys));
                }
            }
            return new KeyBinding(this.description, this.input, keys);
        }

        public String toString() {
            return "KeyBinding.KeyBindingBuilder(description=" + this.description + ", input=" + this.input + ", keys=" + this.keys + ")";
        }
    }
}

