/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.commands;

import com.github.fonimus.ssh.shell.ExtendedShell;
import com.github.fonimus.ssh.shell.SshContext;
import com.github.fonimus.ssh.shell.SshShellCommandFactory;
import com.github.fonimus.ssh.shell.SshShellHelper;
import com.github.fonimus.ssh.shell.commands.SshShellComponent;
import com.github.fonimus.ssh.shell.interactive.Interactive;
import com.github.fonimus.ssh.shell.interactive.InteractiveInputIO;
import com.github.fonimus.ssh.shell.postprocess.PostProcessorObject;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jline.reader.Parser;
import org.jline.utils.AttributedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.annotation.Lazy;
import org.springframework.shell.InputProvider;
import org.springframework.shell.jline.FileInputProvider;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;
import org.springframework.shell.standard.commands.Script;

@SshShellComponent
@ShellCommandGroup(value="Built-In Commands")
@Lazy
public class ScriptCommand
implements Script.Command,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptCommand.class);
    private final ExtendedShell shell;
    private final Parser parser;
    private final SshShellHelper helper;
    private ExecutorService executor;
    private ScriptStatus status;

    public ScriptCommand(ExtendedShell shell, Parser parser, SshShellHelper helper) {
        this.shell = shell;
        this.parser = parser;
        this.helper = helper;
    }

    public void destroy() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ShellMethod(value="Read and execute commands from a file.")
    public void script(@ShellOption(value={"-f", "--file"}, help="File to run commands from", defaultValue="__NULL__") File file, @ShellOption(value={"-o", "--output"}, help="File to write results to", defaultValue="__NULL__") File output, @ShellOption(value={"-b", "--background"}, help="File to run commands from", defaultValue="false") boolean background, @ShellOption(value={"-a", "--action"}, help="Action : execute, stop, status (default is execute)", defaultValue="execute") ScriptAction action, @ShellOption(value={"-n", "--not-interactive"}, help="Do not launch status directly to get interactive process", defaultValue="false") boolean notInteractive) throws IOException {
        if (action == ScriptAction.execute) {
            if (file == null) {
                throw new IllegalArgumentException("File is mandatory");
            }
            if (!background) {
                this.run(file);
                return;
            } else {
                if (output == null) {
                    throw new IllegalArgumentException("Cannot use background option without output option for commands results");
                }
                if (output.isDirectory()) {
                    throw new IllegalArgumentException("Cannot use given output : it is a directory [" + output.getAbsolutePath() + "]");
                }
                if (!output.exists() && !output.createNewFile()) {
                    throw new IllegalArgumentException("Cannot use given output : unable to create file [" + output.getAbsolutePath() + "]");
                }
                if (this.status != null && !this.status.getFuture().isDone()) {
                    this.helper.printWarning("Script already running in background. Aborting.");
                    return;
                }
                try (Stream<String> lines = Files.lines(file.toPath());){
                    long count = lines.count();
                    SshContext ctx = new SshContext();
                    ctx.setBackground(true);
                    ctx.getPostProcessorsList().add(new PostProcessorObject("save", Collections.singletonList(output.getAbsolutePath())));
                    this.status = new ScriptStatus(this.executor().submit(() -> {
                        SshShellCommandFactory.SSH_THREAD_CONTEXT.set(ctx);
                        try {
                            this.run(file);
                        }
                        catch (IOException e) {
                            LOGGER.warn("Unable to run script command : {}", (Object)e.getMessage(), (Object)e);
                        }
                    }), output, count, ctx);
                    this.helper.print("Script from file starting un background. Please check results at " + output.getAbsolutePath() + ".");
                    if (notInteractive) return;
                    this.progress(this.status);
                    return;
                }
            }
        } else if (action == ScriptAction.stop) {
            if (this.status != null && !this.status.getFuture().isDone()) {
                this.status.getFuture().cancel(true);
            }
            this.printStatus(this.status);
            return;
        } else if (this.status != null && !this.status.getFuture().isDone()) {
            this.progress(this.status);
            return;
        } else {
            this.printStatus(this.status);
        }
    }

    private void printStatus(ScriptStatus status) {
        if (status == null) {
            this.helper.print("No script running in background.");
        } else if (status.getFuture().isDone()) {
            String doneOrCancelled = status.getFuture().isCancelled() ? "stopped" : "done";
            this.helper.print("Script " + doneOrCancelled + ". " + status.getCount() + " commands executed.");
        }
    }

    private void progress(ScriptStatus status) {
        this.helper.interactive(Interactive.builder().input((size, currentDelay) -> {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("Script still running. " + status.getCount() + "/" + status.getTotal() + " commands executed so far.");
            lines.add(this.helper.progress((int)status.getCount(), (int)status.getTotal()));
            lines.add("Please press key 'q' to quit, '+' and '-' to increase or decrease refresh delay\n");
            return new InteractiveInputIO(status.getFuture().isDone() || status.getFuture().isCancelled(), lines.stream().map(AttributedString::new).collect(Collectors.toList()));
        }).fullScreen(false).refreshDelay(1000L).build());
        if (status.getFuture().isDone() || status.getFuture().isCancelled()) {
            this.helper.print("Script done. " + status.getCount() + " commands executed.");
        }
    }

    private void run(File file) throws IOException {
        FileReader reader = new FileReader(file);
        try (FileInputProvider inputProvider = new FileInputProvider((Reader)reader, this.parser);){
            this.shell.run((InputProvider)inputProvider, () -> this.status != null && this.status.getFuture().isCancelled());
        }
    }

    private ExecutorService executor() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        return this.executor;
    }

    public static class ScriptStatus {
        private Future<?> future;
        private File result;
        private long total;
        private SshContext sshContext;

        public long getCount() {
            return this.sshContext.getBackgroundCount();
        }

        public Future<?> getFuture() {
            return this.future;
        }

        public File getResult() {
            return this.result;
        }

        public long getTotal() {
            return this.total;
        }

        public SshContext getSshContext() {
            return this.sshContext;
        }

        public void setFuture(Future<?> future) {
            this.future = future;
        }

        public void setResult(File result) {
            this.result = result;
        }

        public void setTotal(long total) {
            this.total = total;
        }

        public void setSshContext(SshContext sshContext) {
            this.sshContext = sshContext;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScriptStatus)) {
                return false;
            }
            ScriptStatus other = (ScriptStatus)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTotal() != other.getTotal()) {
                return false;
            }
            Future<?> this$future = this.getFuture();
            Future<?> other$future = other.getFuture();
            if (this$future == null ? other$future != null : !this$future.equals(other$future)) {
                return false;
            }
            File this$result = this.getResult();
            File other$result = other.getResult();
            if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
                return false;
            }
            SshContext this$sshContext = this.getSshContext();
            SshContext other$sshContext = other.getSshContext();
            return !(this$sshContext == null ? other$sshContext != null : !this$sshContext.equals(other$sshContext));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScriptStatus;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $total = this.getTotal();
            result = result * 59 + (int)($total >>> 32 ^ $total);
            Future<?> $future = this.getFuture();
            result = result * 59 + ($future == null ? 43 : $future.hashCode());
            File $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
            SshContext $sshContext = this.getSshContext();
            result = result * 59 + ($sshContext == null ? 43 : $sshContext.hashCode());
            return result;
        }

        public String toString() {
            return "ScriptCommand.ScriptStatus(future=" + this.getFuture() + ", result=" + this.getResult() + ", total=" + this.getTotal() + ", sshContext=" + this.getSshContext() + ")";
        }

        public ScriptStatus(Future<?> future, File result, long total, SshContext sshContext) {
            this.future = future;
            this.result = result;
            this.total = total;
            this.sshContext = sshContext;
        }
    }

    public static enum ScriptAction {
        execute,
        stop,
        status;

    }
}

