/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.commands;

import com.github.fonimus.ssh.shell.SimpleTable;
import com.github.fonimus.ssh.shell.SshShellHelper;
import com.github.fonimus.ssh.shell.SshShellProperties;
import com.github.fonimus.ssh.shell.commands.AbstractCommand;
import com.github.fonimus.ssh.shell.commands.ObjectNameValuesProvider;
import com.github.fonimus.ssh.shell.commands.SshShellComponent;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.shell.Availability;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;
import org.springframework.shell.standard.ShellOption;

@SshShellComponent
@ShellCommandGroup(value="Jmx Commands")
@ConditionalOnProperty(name={"ssh.shell.commands.jmx.create"}, havingValue="true", matchIfMissing=true)
public class JmxCommand
extends AbstractCommand {
    public static final String GROUP = "jmx";
    private static final String COMMAND_JMX_LIST = "jmx-list";
    private static final String COMMAND_JMX_INFO = "jmx-info";
    private static final String COMMAND_JMX_INVOKE = "jmx-invoke";
    private static final String OBJECT_NAME_EXAMPLE = "org.springframework.boot:type=Endpoint,name=Info";

    public JmxCommand(SshShellHelper helper, SshShellProperties properties) {
        super(helper, properties, properties.getCommands().getJmx());
    }

    @ShellMethod(key={"jmx-list"}, value="List jmx mbeans.")
    @ShellMethodAvailability(value={"jmxListAvailability"})
    public void jmxList(@ShellOption(help="Pattern to search for (ex: org.springframework.boot:*, org.springframework.boot:type=Endpoint,name=*, org.springframework.boot:type=Endpoint,name=Info)", defaultValue="__NULL__") String pattern) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName patternName = pattern != null ? ObjectName.getInstance(pattern) : null;
            SimpleTable.SimpleTableBuilder builder = SimpleTable.builder().column("Object name").column("Class name");
            Set<ObjectInstance> result = server.queryMBeans(patternName, null);
            for (ObjectInstance objectInstance : result.stream().sorted(Comparator.comparing(ObjectInstance::getObjectName)).collect(Collectors.toList())) {
                builder.line(Arrays.asList(objectInstance.getObjectName().toString(), objectInstance.getClassName()));
            }
            this.helper.print(this.helper.renderTable(builder.build()));
            this.helper.print("\nNote: mBean count : " + server.getMBeanCount());
        }
        catch (MalformedObjectNameException e) {
            this.helper.printError("Pattern [" + pattern + "] is not in expected format (expected example : " + OBJECT_NAME_EXAMPLE + "). " + e.getMessage());
        }
    }

    @ShellMethod(key={"jmx-info"}, value="Displays information about jmx mbean. Use -a option to query attribute values.")
    @ShellMethodAvailability(value={"jmxInfoAvailability"})
    public void jmxInfo(@ShellOption(value={"-n", "--object-name"}, help="Object name (ex: org.springframework.boot:type=Endpoint,name=Info)", valueProvider=ObjectNameValuesProvider.class) String objectName, @ShellOption(value={"-a", "--all-attributes-value"}, help="Get all attributes", defaultValue="__NULL__") Boolean allAttributesValues) throws JMException {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectNameBean = ObjectName.getInstance(objectName);
            MBeanInfo info = server.getMBeanInfo(objectNameBean);
            StringBuilder sb = new StringBuilder();
            sb.append("\n").append("Object name : ").append(objectName).append("\n").append("Class name  : ").append(info.getClassName()).append("\n").append("Description : ").append(info.getDescription()).append("\n");
            SimpleTable.SimpleTableBuilder builder = SimpleTable.builder().column("Field name").column("Field value");
            for (String fieldName : info.getDescriptor().getFieldNames()) {
                builder.line(Arrays.asList(fieldName, info.getDescriptor().getFieldValue(fieldName)));
            }
            sb.append("Descriptor  : ").append("\n").append(this.helper.renderTable(builder.build()));
            builder = SimpleTable.builder().column("Name").column("Type").column("Description");
            if (allAttributesValues != null && allAttributesValues.booleanValue()) {
                builder.column("Value");
            }
            if (info.getAttributes().length > 0) {
                for (MBeanAttributeInfo attribute : info.getAttributes()) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(attribute.getName());
                    list.add(attribute.getType());
                    list.add(attribute.getDescription());
                    if (allAttributesValues != null && allAttributesValues.booleanValue()) {
                        if (attribute.isReadable()) {
                            try {
                                list.add(server.getAttribute(objectNameBean, attribute.getName()));
                            }
                            catch (JMException e) {
                                list.add("Error while reading attribute : " + e.getMessage());
                            }
                        } else {
                            list.add("Not readable");
                        }
                    }
                    builder.line(list);
                }
                sb.append("Attributes  : ").append("\n").append(this.helper.renderTable(builder.build()));
            }
            builder = SimpleTable.builder().column("Name").column("Description").column("Impact").column("Return type").column("Parameters");
            if (info.getOperations().length > 0) {
                for (MBeanOperationInfo operation : info.getOperations()) {
                    builder.line(Arrays.asList(operation.getName(), operation.getDescription(), this.impact(operation.getImpact()), operation.getReturnType(), Arrays.stream(operation.getSignature()).map(p -> p.getName() + ":" + p.getType()).collect(Collectors.toList())));
                }
                sb.append("Operations  : ").append("\n").append(this.helper.renderTable(builder.build()));
            }
            this.helper.print(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            this.helper.printError("Object name [" + objectName + "] is not in expected format (expected example : " + OBJECT_NAME_EXAMPLE + "). " + e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            this.helper.printWarning("Instance not found for name [" + objectName + "]. Check available object names with command jmx-list");
        }
    }

    @ShellMethod(key={"jmx-invoke"}, value="Invoke operation on object name.")
    @ShellMethodAvailability(value={"jmxInvokeAvailability"})
    public Object jmxInvoke(@ShellOption(value={"-n", "--object-name"}, help="Object name (ex: org.springframework.boot:type=Endpoint,name=Info)", valueProvider=ObjectNameValuesProvider.class) String objectName, @ShellOption(value={"-o", "--operation-name"}, help="Operation name (ex: info, for spring boot info mbean)") String operationName, @ShellOption(value={"-p", "--parameters"}, help="Parameters", defaultValue="__NULL__") String parametersParam) throws JMException {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectNameBean = ObjectName.getInstance(objectName);
            MBeanInfo info = server.getMBeanInfo(objectNameBean);
            MBeanOperationInfo operation = null;
            for (MBeanOperationInfo o : info.getOperations()) {
                if (!o.getName().equals(operationName)) continue;
                operation = o;
            }
            if (operation == null) {
                this.helper.printError("Object name [" + objectName + "] does not have operation with name [" + operationName + "]. Available are : " + Arrays.stream(info.getOperations()).map(MBeanFeatureInfo::getName).collect(Collectors.joining()));
            } else {
                Object[] parameters = parametersParam != null ? parametersParam.split(",") : new Object[]{};
                String[] signature = parametersParam != null ? (String[])Arrays.stream(operation.getSignature()).map(MBeanParameterInfo::getType).toArray(String[]::new) : new String[]{};
                Object result = server.invoke(objectNameBean, operationName, parameters, signature);
                this.helper.printSuccess("Operation [" + operationName + "] invoked on mbean [" + objectName + "] successfully");
                if (result != null) {
                    return result;
                }
            }
        }
        catch (MalformedObjectNameException e) {
            this.helper.printError("Object name [" + objectName + "] is not in expected format (expected example : " + OBJECT_NAME_EXAMPLE + "). " + e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            this.helper.printWarning("Instance not found for name [" + objectName + "]. Check available object names with command jmx-list");
        }
        return null;
    }

    private Object impact(int impact) {
        switch (impact) {
            case 1: {
                return "action";
            }
            case 2: {
                return "action/info";
            }
            case 0: {
                return "info";
            }
            case 3: {
                return "unknown";
            }
        }
        return "(" + impact + ")";
    }

    private Availability jmxListAvailability() {
        return this.availability(GROUP, COMMAND_JMX_LIST);
    }

    private Availability jmxInfoAvailability() {
        return this.availability(GROUP, COMMAND_JMX_INFO);
    }

    private Availability jmxInvokeAvailability() {
        return this.availability(GROUP, COMMAND_JMX_INVOKE);
    }
}

