/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.shell.CompletionContext;
import org.springframework.shell.CompletionProposal;
import org.springframework.shell.standard.ValueProviderSupport;
import org.springframework.stereotype.Component;

@Component
class DatasourceIndexValuesProvider
extends ValueProviderSupport {
    private final Map<Integer, DataSource> dataSourceByIndex = new HashMap<Integer, DataSource>();

    public DatasourceIndexValuesProvider(@Autowired(required=false) List<DataSource> dataSourceList) {
        if (dataSourceList != null) {
            this.dataSourceByIndex.putAll(IntStream.range(0, dataSourceList.size()).boxed().collect(Collectors.toMap(Function.identity(), dataSourceList::get)));
        }
    }

    public List<CompletionProposal> complete(MethodParameter parameter, CompletionContext completionContext, String[] hints) {
        return this.dataSourceByIndex.keySet().stream().map(i -> new CompletionProposal("" + i)).collect(Collectors.toList());
    }
}

