/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.commands;

import com.github.fonimus.ssh.shell.SimpleTable;
import com.github.fonimus.ssh.shell.SshShellHelper;
import com.github.fonimus.ssh.shell.SshShellProperties;
import com.github.fonimus.ssh.shell.commands.AbstractCommand;
import com.github.fonimus.ssh.shell.commands.DatasourceIndexValuesProvider;
import com.github.fonimus.ssh.shell.commands.SshShellComponent;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.shell.Availability;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;
import org.springframework.shell.standard.ShellOption;

@SshShellComponent
@ShellCommandGroup(value="Datasource Commands")
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnClass(value={DataSource.class})
@ConditionalOnProperty(name={"ssh.shell.commands.datasource.create"}, havingValue="true", matchIfMissing=true)
public class DatasourceCommand
extends AbstractCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasourceCommand.class);
    public static final String GROUP = "datasource";
    private static final String COMMAND_DATA_SOURCE_LIST = "datasource-list";
    private static final String COMMAND_DATA_SOURCE_PROPERTIES = "datasource-properties";
    private static final String COMMAND_DATA_SOURCE_QUERY = "datasource-query";
    public static final String COMMAND_DATA_SOURCE_UPDATE = "datasource-update";
    private final Map<Integer, DataSource> dataSourceByIndex = new HashMap<Integer, DataSource>();

    public DatasourceCommand(SshShellHelper helper, SshShellProperties properties, @Autowired(required=false) List<DataSource> dataSourceList) {
        super(helper, properties, properties.getCommands().getDatasource());
        if (dataSourceList != null) {
            this.dataSourceByIndex.putAll(IntStream.range(0, dataSourceList.size()).boxed().collect(Collectors.toMap(Function.identity(), dataSourceList::get)));
        }
    }

    @ShellMethod(key={"datasource-list"}, value="List available datasources")
    @ShellMethodAvailability(value={"datasourceListAvailability"})
    public String datasourceList() {
        if (this.dataSourceByIndex.isEmpty()) {
            this.helper.printWarning("No datasource found in context.");
            return null;
        }
        SimpleTable.SimpleTableBuilder builder = SimpleTable.builder().column("Id").column("Name").column("Url").column("Username").column("Product").column("Error");
        for (Map.Entry<Integer, DataSource> entry : this.dataSourceByIndex.entrySet()) {
            try {
                Connection connection = entry.getValue().getConnection();
                try {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    builder.line(Arrays.asList(entry.getKey(), entry.getValue().toString(), databaseMetaData.getURL(), databaseMetaData.getUserName(), databaseMetaData.getDatabaseProductName() + " " + databaseMetaData.getDatabaseProductVersion(), "-"));
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
            catch (SQLException e) {
                LOGGER.warn("Unable to get datasource information for [{}] : {}-{}", new Object[]{entry.getValue().toString(), e.getErrorCode(), e.getMessage()});
                String url = this.find(entry.getValue(), "-", "jdbcUrl", "url");
                String userName = this.find(entry.getValue(), "-", "username", "user");
                builder.line(Arrays.asList(entry.getKey(), entry.getValue().toString(), url, userName, "-", "Unable to get datasource information for [" + url + "] : " + e.getErrorCode() + "-" + e.getMessage()));
            }
        }
        return this.helper.renderTable(builder.build());
    }

    private String find(Object object, String defaultValue, String ... fieldNames) {
        if (fieldNames != null) {
            for (String fieldName : fieldNames) {
                try {
                    PropertyDescriptor pd = new PropertyDescriptor(fieldName, object.getClass());
                    Object result = pd.getReadMethod().invoke(object, new Object[0]);
                    if (result != null) {
                        return result.toString();
                    }
                }
                catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                    LOGGER.debug("Unable to access field [{}] on class [{}]", new Object[]{fieldName, object.getClass(), e});
                }
            }
        }
        return defaultValue;
    }

    @ShellMethod(key={"datasource-properties"}, value="Datasource properties command. Executes 'show variables'")
    @ShellMethodAvailability(value={"datasourcePropertiesAvailability"})
    public String datasourceProperties(@ShellOption(value={"-i", "--identifier"}, help="Datasource identifier", valueProvider=DatasourceIndexValuesProvider.class) int id, @ShellOption(value={"-f", "--filter"}, help="Add like %<filter>% to sql query", defaultValue="__NULL__") String filter) {
        String query = "show variables";
        if (filter != null) {
            query = query + " LIKE '%" + filter + "%'";
        }
        return this.datasourceQuery(id, query);
    }

    @ShellMethod(key={"datasource-query"}, value="Datasource query command.")
    @ShellMethodAvailability(value={"datasourceQueryAvailability"})
    public String datasourceQuery(@ShellOption(value={"-i", "--identifier"}, help="Datasource identifier", valueProvider=DatasourceIndexValuesProvider.class) int id, @ShellOption(value={"-q", "--query"}, help="SQL query to execute") String query) {
        StringBuilder sb = new StringBuilder();
        DataSource ds = this.getOrDie(id);
        try (Connection connection = ds.getConnection();){
            sb.append("Query [").append(query).append("] for datasource : ").append(ds.toString()).append(" (").append(connection.getMetaData().getURL()).append(")\n");
            try (Statement statement = connection.createStatement();
                 ResultSet rs = statement.executeQuery(query);){
                if (rs.getType() == 1003 || rs.getType() == 1004 || rs.getType() == 1005) {
                    SimpleTable.SimpleTableBuilder builder = SimpleTable.builder();
                    for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                        builder.column(rs.getMetaData().getColumnName(i));
                    }
                    while (rs.next()) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                            list.add(rs.getString(i));
                        }
                        builder.line(list);
                    }
                    sb.append(this.helper.renderTable(builder.build()));
                }
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to execute SQL query : " + e.getMessage(), e);
        }
        return sb.toString();
    }

    @ShellMethod(key={"datasource-update"}, value="Datasource update command.")
    @ShellMethodAvailability(value={"datasourceUpdateAvailability"})
    public void datasourceUpdate(@ShellOption(value={"-i", "--identifier"}, help="Datasource identifier", valueProvider=DatasourceIndexValuesProvider.class) int id, @ShellOption(value={"-u", "--update"}, help="SQL update to execute") String update) {
        DataSource ds = this.getOrDie(id);
        try (Connection connection = ds.getConnection();
             Statement statement = connection.createStatement();){
            int result = statement.executeUpdate(update);
            this.helper.printSuccess("Query [" + update + "] for datasource : [" + ds.toString() + " (" + connection.getMetaData().getURL() + ")] updated " + result + " row(s)");
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to execute SQL update : " + e.getMessage(), e);
        }
    }

    private DataSource getOrDie(int index) {
        DataSource ds = this.dataSourceByIndex.get(index);
        if (ds == null) {
            throw new IllegalArgumentException("Cannot find datasource with identifier [" + index + "]");
        }
        return ds;
    }

    private Availability datasourceListAvailability() {
        return this.availability(GROUP, COMMAND_DATA_SOURCE_LIST);
    }

    private Availability datasourcePropertiesAvailability() {
        return this.availability(GROUP, COMMAND_DATA_SOURCE_PROPERTIES);
    }

    private Availability datasourceQueryAvailability() {
        return this.availability(GROUP, COMMAND_DATA_SOURCE_QUERY);
    }

    private Availability datasourceUpdateAvailability() {
        return this.availability(GROUP, COMMAND_DATA_SOURCE_UPDATE);
    }
}

