/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.auth;

import com.github.fonimus.ssh.shell.auth.SshAuthentication;
import com.github.fonimus.ssh.shell.auth.SshShellAuthenticationProvider;
import java.util.UUID;
import org.apache.sshd.server.auth.password.PasswordChangeRequiredException;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshShellPasswordAuthenticationProvider
implements SshShellAuthenticationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SshShellPasswordAuthenticationProvider.class);
    private final String user;
    private final String password;

    public SshShellPasswordAuthenticationProvider(String user, String password) {
        this.user = user;
        String pass = password;
        if (pass == null) {
            pass = UUID.randomUUID().toString();
            LOGGER.info(" --- Generating password for ssh connection: {}", (Object)pass);
        }
        this.password = pass;
    }

    public boolean authenticate(String username, String pass, ServerSession serverSession) throws PasswordChangeRequiredException {
        serverSession.getIoSession().setAttribute((Object)"authentication", (Object)new SshAuthentication(username, username));
        return username.equals(this.user) && pass.equals(this.password);
    }
}

