/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell;

import com.github.fonimus.ssh.shell.PromptColor;
import com.github.fonimus.ssh.shell.commands.CommandProperties;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="ssh.shell")
@Validated
public class SshShellProperties {
    public static final String SSH_SHELL_PREFIX = "ssh.shell";
    public static final String SSH_SHELL_ENABLE = "ssh.shell.enable";
    public static final String DISABLE_SSH_SHELL = "ssh.shell.enable=false";
    public static final String SPRING_SHELL_AUTO_CONFIG_CLASSES = "org.springframework.shell.jline.JLineShellAutoConfiguration,org.springframework.shell.SpringShellAutoConfiguration,org.springframework.shell.jcommander.JCommanderParameterResolverAutoConfiguration,org.springframework.shell.legacy.LegacyAdapterAutoConfiguration,org.springframework.shell.standard.StandardAPIAutoConfiguration,org.springframework.shell.standard.commands.StandardCommandsAutoConfiguration";
    public static final String DISABLE_SPRING_SHELL_AUTO_CONFIG = "spring.autoconfigure.exclude=org.springframework.shell.jline.JLineShellAutoConfiguration,org.springframework.shell.SpringShellAutoConfiguration,org.springframework.shell.jcommander.JCommanderParameterResolverAutoConfiguration,org.springframework.shell.legacy.LegacyAdapterAutoConfiguration,org.springframework.shell.standard.StandardAPIAutoConfiguration,org.springframework.shell.standard.commands.StandardCommandsAutoConfiguration";
    public static final String ACTUATOR_ROLE = "ACTUATOR";
    public static final String ADMIN_ROLE = "ADMIN";
    private boolean enable = true;
    private String host = "127.0.0.1";
    private int port = 2222;
    private String user = "user";
    private String password;
    private boolean displayBanner = true;
    private boolean extendedFileProvider = true;
    private AuthenticationType authentication = AuthenticationType.simple;
    private String authProviderBeanName;
    private File hostKeyFile = new File(System.getProperty("java.io.tmpdir"), "hostKey.ser");
    private Resource authorizedPublicKeys;
    private File historyFile = new File(System.getProperty("java.io.tmpdir"), "sshShellHistory.log");
    private boolean sharedHistory = true;
    private File historyDirectory = new File(System.getProperty("java.io.tmpdir"));
    private List<String> confirmationWords;
    private Prompt prompt = new Prompt();
    private Commands commands = new Commands();

    public void setAuthorizedPublicKeysFile(File file) {
        this.authorizedPublicKeys = new FileSystemResource(file);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isDisplayBanner() {
        return this.displayBanner;
    }

    public boolean isExtendedFileProvider() {
        return this.extendedFileProvider;
    }

    public AuthenticationType getAuthentication() {
        return this.authentication;
    }

    public String getAuthProviderBeanName() {
        return this.authProviderBeanName;
    }

    public File getHostKeyFile() {
        return this.hostKeyFile;
    }

    public Resource getAuthorizedPublicKeys() {
        return this.authorizedPublicKeys;
    }

    public File getHistoryFile() {
        return this.historyFile;
    }

    public boolean isSharedHistory() {
        return this.sharedHistory;
    }

    public File getHistoryDirectory() {
        return this.historyDirectory;
    }

    public List<String> getConfirmationWords() {
        return this.confirmationWords;
    }

    public Prompt getPrompt() {
        return this.prompt;
    }

    public Commands getCommands() {
        return this.commands;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDisplayBanner(boolean displayBanner) {
        this.displayBanner = displayBanner;
    }

    public void setExtendedFileProvider(boolean extendedFileProvider) {
        this.extendedFileProvider = extendedFileProvider;
    }

    public void setAuthentication(AuthenticationType authentication) {
        this.authentication = authentication;
    }

    public void setAuthProviderBeanName(String authProviderBeanName) {
        this.authProviderBeanName = authProviderBeanName;
    }

    public void setHostKeyFile(File hostKeyFile) {
        this.hostKeyFile = hostKeyFile;
    }

    public void setAuthorizedPublicKeys(Resource authorizedPublicKeys) {
        this.authorizedPublicKeys = authorizedPublicKeys;
    }

    public void setHistoryFile(File historyFile) {
        this.historyFile = historyFile;
    }

    public void setSharedHistory(boolean sharedHistory) {
        this.sharedHistory = sharedHistory;
    }

    public void setHistoryDirectory(File historyDirectory) {
        this.historyDirectory = historyDirectory;
    }

    public void setConfirmationWords(List<String> confirmationWords) {
        this.confirmationWords = confirmationWords;
    }

    public void setPrompt(Prompt prompt) {
        this.prompt = prompt;
    }

    public void setCommands(Commands commands) {
        this.commands = commands;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SshShellProperties)) {
            return false;
        }
        SshShellProperties other = (SshShellProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isDisplayBanner() != other.isDisplayBanner()) {
            return false;
        }
        if (this.isExtendedFileProvider() != other.isExtendedFileProvider()) {
            return false;
        }
        if (this.isSharedHistory() != other.isSharedHistory()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        AuthenticationType this$authentication = this.getAuthentication();
        AuthenticationType other$authentication = other.getAuthentication();
        if (this$authentication == null ? other$authentication != null : !((Object)((Object)this$authentication)).equals((Object)other$authentication)) {
            return false;
        }
        String this$authProviderBeanName = this.getAuthProviderBeanName();
        String other$authProviderBeanName = other.getAuthProviderBeanName();
        if (this$authProviderBeanName == null ? other$authProviderBeanName != null : !this$authProviderBeanName.equals(other$authProviderBeanName)) {
            return false;
        }
        File this$hostKeyFile = this.getHostKeyFile();
        File other$hostKeyFile = other.getHostKeyFile();
        if (this$hostKeyFile == null ? other$hostKeyFile != null : !((Object)this$hostKeyFile).equals(other$hostKeyFile)) {
            return false;
        }
        Resource this$authorizedPublicKeys = this.getAuthorizedPublicKeys();
        Resource other$authorizedPublicKeys = other.getAuthorizedPublicKeys();
        if (this$authorizedPublicKeys == null ? other$authorizedPublicKeys != null : !this$authorizedPublicKeys.equals(other$authorizedPublicKeys)) {
            return false;
        }
        File this$historyFile = this.getHistoryFile();
        File other$historyFile = other.getHistoryFile();
        if (this$historyFile == null ? other$historyFile != null : !((Object)this$historyFile).equals(other$historyFile)) {
            return false;
        }
        File this$historyDirectory = this.getHistoryDirectory();
        File other$historyDirectory = other.getHistoryDirectory();
        if (this$historyDirectory == null ? other$historyDirectory != null : !((Object)this$historyDirectory).equals(other$historyDirectory)) {
            return false;
        }
        List<String> this$confirmationWords = this.getConfirmationWords();
        List<String> other$confirmationWords = other.getConfirmationWords();
        if (this$confirmationWords == null ? other$confirmationWords != null : !((Object)this$confirmationWords).equals(other$confirmationWords)) {
            return false;
        }
        Prompt this$prompt = this.getPrompt();
        Prompt other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !((Object)this$prompt).equals(other$prompt)) {
            return false;
        }
        Commands this$commands = this.getCommands();
        Commands other$commands = other.getCommands();
        return !(this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SshShellProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isDisplayBanner() ? 79 : 97);
        result = result * 59 + (this.isExtendedFileProvider() ? 79 : 97);
        result = result * 59 + (this.isSharedHistory() ? 79 : 97);
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        AuthenticationType $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : ((Object)((Object)$authentication)).hashCode());
        String $authProviderBeanName = this.getAuthProviderBeanName();
        result = result * 59 + ($authProviderBeanName == null ? 43 : $authProviderBeanName.hashCode());
        File $hostKeyFile = this.getHostKeyFile();
        result = result * 59 + ($hostKeyFile == null ? 43 : ((Object)$hostKeyFile).hashCode());
        Resource $authorizedPublicKeys = this.getAuthorizedPublicKeys();
        result = result * 59 + ($authorizedPublicKeys == null ? 43 : $authorizedPublicKeys.hashCode());
        File $historyFile = this.getHistoryFile();
        result = result * 59 + ($historyFile == null ? 43 : ((Object)$historyFile).hashCode());
        File $historyDirectory = this.getHistoryDirectory();
        result = result * 59 + ($historyDirectory == null ? 43 : ((Object)$historyDirectory).hashCode());
        List<String> $confirmationWords = this.getConfirmationWords();
        result = result * 59 + ($confirmationWords == null ? 43 : ((Object)$confirmationWords).hashCode());
        Prompt $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : ((Object)$prompt).hashCode());
        Commands $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        return result;
    }

    public String toString() {
        return "SshShellProperties(enable=" + this.isEnable() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", displayBanner=" + this.isDisplayBanner() + ", extendedFileProvider=" + this.isExtendedFileProvider() + ", authentication=" + (Object)((Object)this.getAuthentication()) + ", authProviderBeanName=" + this.getAuthProviderBeanName() + ", hostKeyFile=" + this.getHostKeyFile() + ", authorizedPublicKeys=" + this.getAuthorizedPublicKeys() + ", historyFile=" + this.getHistoryFile() + ", sharedHistory=" + this.isSharedHistory() + ", historyDirectory=" + this.getHistoryDirectory() + ", confirmationWords=" + this.getConfirmationWords() + ", prompt=" + this.getPrompt() + ", commands=" + this.getCommands() + ")";
    }

    public static class Commands {
        @NestedConfigurationProperty
        private CommandProperties actuator = CommandProperties.withAuthorizedRoles(Arrays.asList("ACTUATOR"));
        @NestedConfigurationProperty
        private CommandProperties jmx = new CommandProperties();
        @NestedConfigurationProperty
        private CommandProperties system = new CommandProperties();
        @NestedConfigurationProperty
        private CommandProperties tasks = new CommandProperties();
        @NestedConfigurationProperty
        private CommandProperties datasource = CommandProperties.withExcludedByDefault(Arrays.asList("datasource-update"));
        @NestedConfigurationProperty
        private CommandProperties postprocessors = CommandProperties.notRestrictedByDefault();
        @NestedConfigurationProperty
        private CommandProperties manageSessions = CommandProperties.disabledByDefault();

        public CommandProperties getActuator() {
            return this.actuator;
        }

        public CommandProperties getJmx() {
            return this.jmx;
        }

        public CommandProperties getSystem() {
            return this.system;
        }

        public CommandProperties getTasks() {
            return this.tasks;
        }

        public CommandProperties getDatasource() {
            return this.datasource;
        }

        public CommandProperties getPostprocessors() {
            return this.postprocessors;
        }

        public CommandProperties getManageSessions() {
            return this.manageSessions;
        }

        public void setActuator(CommandProperties actuator) {
            this.actuator = actuator;
        }

        public void setJmx(CommandProperties jmx) {
            this.jmx = jmx;
        }

        public void setSystem(CommandProperties system) {
            this.system = system;
        }

        public void setTasks(CommandProperties tasks) {
            this.tasks = tasks;
        }

        public void setDatasource(CommandProperties datasource) {
            this.datasource = datasource;
        }

        public void setPostprocessors(CommandProperties postprocessors) {
            this.postprocessors = postprocessors;
        }

        public void setManageSessions(CommandProperties manageSessions) {
            this.manageSessions = manageSessions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Commands)) {
                return false;
            }
            Commands other = (Commands)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CommandProperties this$actuator = this.getActuator();
            CommandProperties other$actuator = other.getActuator();
            if (this$actuator == null ? other$actuator != null : !((Object)this$actuator).equals(other$actuator)) {
                return false;
            }
            CommandProperties this$jmx = this.getJmx();
            CommandProperties other$jmx = other.getJmx();
            if (this$jmx == null ? other$jmx != null : !((Object)this$jmx).equals(other$jmx)) {
                return false;
            }
            CommandProperties this$system = this.getSystem();
            CommandProperties other$system = other.getSystem();
            if (this$system == null ? other$system != null : !((Object)this$system).equals(other$system)) {
                return false;
            }
            CommandProperties this$tasks = this.getTasks();
            CommandProperties other$tasks = other.getTasks();
            if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
                return false;
            }
            CommandProperties this$datasource = this.getDatasource();
            CommandProperties other$datasource = other.getDatasource();
            if (this$datasource == null ? other$datasource != null : !((Object)this$datasource).equals(other$datasource)) {
                return false;
            }
            CommandProperties this$postprocessors = this.getPostprocessors();
            CommandProperties other$postprocessors = other.getPostprocessors();
            if (this$postprocessors == null ? other$postprocessors != null : !((Object)this$postprocessors).equals(other$postprocessors)) {
                return false;
            }
            CommandProperties this$manageSessions = this.getManageSessions();
            CommandProperties other$manageSessions = other.getManageSessions();
            return !(this$manageSessions == null ? other$manageSessions != null : !((Object)this$manageSessions).equals(other$manageSessions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Commands;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CommandProperties $actuator = this.getActuator();
            result = result * 59 + ($actuator == null ? 43 : ((Object)$actuator).hashCode());
            CommandProperties $jmx = this.getJmx();
            result = result * 59 + ($jmx == null ? 43 : ((Object)$jmx).hashCode());
            CommandProperties $system = this.getSystem();
            result = result * 59 + ($system == null ? 43 : ((Object)$system).hashCode());
            CommandProperties $tasks = this.getTasks();
            result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
            CommandProperties $datasource = this.getDatasource();
            result = result * 59 + ($datasource == null ? 43 : ((Object)$datasource).hashCode());
            CommandProperties $postprocessors = this.getPostprocessors();
            result = result * 59 + ($postprocessors == null ? 43 : ((Object)$postprocessors).hashCode());
            CommandProperties $manageSessions = this.getManageSessions();
            result = result * 59 + ($manageSessions == null ? 43 : ((Object)$manageSessions).hashCode());
            return result;
        }

        public String toString() {
            return "SshShellProperties.Commands(actuator=" + this.getActuator() + ", jmx=" + this.getJmx() + ", system=" + this.getSystem() + ", tasks=" + this.getTasks() + ", datasource=" + this.getDatasource() + ", postprocessors=" + this.getPostprocessors() + ", manageSessions=" + this.getManageSessions() + ")";
        }
    }

    public static class Local {
        private boolean enable;

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Local)) {
                return false;
            }
            Local other = (Local)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isEnable() == other.isEnable();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Local;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnable() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "SshShellProperties.Local(enable=" + this.isEnable() + ")";
        }
    }

    public static class Prompt {
        private String text = "shell>";
        private PromptColor color = PromptColor.WHITE;
        private Local local = new Local();

        public String getText() {
            return this.text;
        }

        public PromptColor getColor() {
            return this.color;
        }

        public Local getLocal() {
            return this.local;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setColor(PromptColor color) {
            this.color = color;
        }

        public void setLocal(Local local) {
            this.local = local;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Prompt)) {
                return false;
            }
            Prompt other = (Prompt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            PromptColor this$color = this.getColor();
            PromptColor other$color = other.getColor();
            if (this$color == null ? other$color != null : !((Object)((Object)this$color)).equals((Object)other$color)) {
                return false;
            }
            Local this$local = this.getLocal();
            Local other$local = other.getLocal();
            return !(this$local == null ? other$local != null : !((Object)this$local).equals(other$local));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Prompt;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            PromptColor $color = this.getColor();
            result = result * 59 + ($color == null ? 43 : ((Object)((Object)$color)).hashCode());
            Local $local = this.getLocal();
            result = result * 59 + ($local == null ? 43 : ((Object)$local).hashCode());
            return result;
        }

        public String toString() {
            return "SshShellProperties.Prompt(text=" + this.getText() + ", color=" + (Object)((Object)this.getColor()) + ", local=" + this.getLocal() + ")";
        }
    }

    public static enum AuthenticationType {
        simple,
        security;

    }
}

