/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell;

import com.github.fonimus.ssh.shell.SshShellCommandFactory;
import com.github.fonimus.ssh.shell.SshShellProperties;
import com.github.fonimus.ssh.shell.auth.SshShellPublicKeyAuthenticationProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.RejectAllPublickeyAuthenticator;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration
public class SshShellConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SshShellConfiguration.class);
    private SshShellProperties properties;
    private SshShellCommandFactory shellCommandFactory;
    private PasswordAuthenticator passwordAuthenticator;

    public SshShellConfiguration(SshShellProperties properties, SshShellCommandFactory shellCommandFactory, PasswordAuthenticator passwordAuthenticator) {
        this.properties = properties;
        this.shellCommandFactory = shellCommandFactory;
        this.passwordAuthenticator = passwordAuthenticator;
    }

    @Bean
    public SshServerLifecycle sshServerLifecycle(SshServer sshServer) {
        return new SshServerLifecycle(sshServer, this.properties);
    }

    @Bean
    public SshServer sshServer() throws IOException {
        SshServer server = SshServer.setUpDefaultServer();
        server.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(this.properties.getHostKeyFile().toPath()));
        server.setHost(this.properties.getHost());
        server.setPasswordAuthenticator(this.passwordAuthenticator);
        server.setPublickeyAuthenticator((PublickeyAuthenticator)RejectAllPublickeyAuthenticator.INSTANCE);
        if (this.properties.getAuthorizedPublicKeys() != null) {
            if (this.properties.getAuthorizedPublicKeys().exists()) {
                server.setPublickeyAuthenticator((PublickeyAuthenticator)new SshShellPublicKeyAuthenticationProvider(this.getFile(this.properties.getAuthorizedPublicKeys())));
                LOGGER.info("Using authorized public keys from : {}", (Object)this.properties.getAuthorizedPublicKeys().getDescription());
            } else {
                LOGGER.warn("Could not read authorized public keys from : {}, public key authentication is disabled.", (Object)this.properties.getAuthorizedPublicKeys().getDescription());
            }
        }
        server.setPort(this.properties.getPort());
        server.setShellFactory(channelSession -> this.shellCommandFactory);
        server.setCommandFactory((channelSession, s) -> this.shellCommandFactory);
        return server;
    }

    private File getFile(Resource authorizedPublicKeys) throws IOException {
        if ("file".equals(authorizedPublicKeys.getURL().getProtocol())) {
            return authorizedPublicKeys.getFile();
        }
        File tmp = Files.createTempFile("sshShellPubKeys-", ".tmp", new FileAttribute[0]).toFile();
        try (InputStream is = authorizedPublicKeys.getInputStream();
             FileOutputStream os = new FileOutputStream(tmp);){
            IoUtils.copy((InputStream)is, (OutputStream)os);
        }
        tmp.deleteOnExit();
        LOGGER.info("Copying {} to following temporary file : {}", (Object)authorizedPublicKeys, (Object)tmp.getAbsolutePath());
        return tmp;
    }

    public static class SshServerLifecycle {
        private final SshServer sshServer;
        private final SshShellProperties properties;

        @PostConstruct
        public void startServer() throws IOException {
            this.sshServer.start();
            LOGGER.info("Ssh server started [{}:{}]", (Object)this.properties.getHost(), (Object)this.properties.getPort());
        }

        @PreDestroy
        public void stopServer() throws IOException {
            this.sshServer.stop();
        }

        public SshServerLifecycle(SshServer sshServer, SshShellProperties properties) {
            this.sshServer = sshServer;
            this.properties = properties;
        }
    }
}

