/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell;

import com.github.fonimus.ssh.shell.SshContext;
import com.github.fonimus.ssh.shell.SshIO;
import com.github.fonimus.ssh.shell.SshShellProperties;
import com.github.fonimus.ssh.shell.SshShellRunnable;
import com.github.fonimus.ssh.shell.listeners.SshShellListenerService;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.jline.reader.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.Banner;
import org.springframework.context.annotation.Lazy;
import org.springframework.shell.Shell;
import org.springframework.shell.jline.JLineShellAutoConfiguration;
import org.springframework.shell.jline.PromptProvider;
import org.springframework.stereotype.Component;

@Component
public class SshShellCommandFactory
implements Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(SshShellCommandFactory.class);
    public static final ThreadLocal<SshContext> SSH_THREAD_CONTEXT = ThreadLocal.withInitial(() -> null);
    private SshShellProperties properties;
    private SshShellListenerService shellListenerService;
    private Banner shellBanner;
    private PromptProvider promptProvider;
    private Shell shell;
    private JLineShellAutoConfiguration.CompleterAdapter completerAdapter;
    private final Parser parser;
    private org.springframework.core.env.Environment environment;
    public static final ThreadLocal<SshIO> SSH_IO_CONTEXT = ThreadLocal.withInitial(SshIO::new);
    private Map<ChannelSession, Thread> threads = new ConcurrentHashMap<ChannelSession, Thread>();

    public SshShellCommandFactory(SshShellListenerService shellListenerService, @Autowired(required=false) Banner banner, @Lazy PromptProvider promptProvider, Shell shell, JLineShellAutoConfiguration.CompleterAdapter completerAdapter, Parser parser, org.springframework.core.env.Environment environment, SshShellProperties properties) {
        this.shellListenerService = shellListenerService;
        this.shellBanner = banner;
        this.promptProvider = promptProvider;
        this.shell = shell;
        this.completerAdapter = completerAdapter;
        this.parser = parser;
        this.environment = environment;
        this.properties = properties;
    }

    public void start(ChannelSession channelSession, Environment env) {
        SshIO sshIO = SSH_IO_CONTEXT.get();
        Thread sshThread = new Thread(new ThreadGroup("ssh-shell"), new SshShellRunnable(this.properties, channelSession, this.shellListenerService, this.shellBanner, this.promptProvider, this.shell, this.completerAdapter, this.parser, this.environment, env, this, sshIO.getIs(), sshIO.getOs(), sshIO.getEc()), "ssh-session-" + System.nanoTime());
        sshThread.start();
        this.threads.put(channelSession, sshThread);
        LOGGER.debug("{}: started [{} session(s) currently active]", (Object)channelSession, (Object)this.threads.size());
    }

    public void destroy(ChannelSession channelSession) {
        Thread sshThread = this.threads.remove(channelSession);
        if (sshThread != null) {
            sshThread.interrupt();
        }
        LOGGER.debug("{}: destroyed [{} session(s) currently active]", (Object)channelSession, (Object)this.threads.size());
    }

    public void setErrorStream(OutputStream errOS) {
    }

    public void setExitCallback(ExitCallback ec) {
        SSH_IO_CONTEXT.get().setEc(ec);
    }

    public void setInputStream(InputStream is) {
        SSH_IO_CONTEXT.get().setIs(is);
    }

    public void setOutputStream(OutputStream os) {
        SSH_IO_CONTEXT.get().setOs(os);
    }

    public Map<Long, ChannelSession> listSessions() {
        return this.threads.keySet().stream().collect(Collectors.toMap(s -> s.getServerSession().getIoSession().getId(), Function.identity()));
    }
}

