/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell;

import com.github.fonimus.ssh.shell.ExtendedInput;
import com.github.fonimus.ssh.shell.SshContext;
import com.github.fonimus.ssh.shell.SshShellCommandFactory;
import com.github.fonimus.ssh.shell.postprocess.PostProcessor;
import com.github.fonimus.ssh.shell.postprocess.PostProcessorObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.CompletionContext;
import org.springframework.shell.CompletionProposal;
import org.springframework.shell.ExitRequest;
import org.springframework.shell.Input;
import org.springframework.shell.InputProvider;
import org.springframework.shell.ResultHandler;
import org.springframework.shell.Shell;

public class ExtendedShell
extends Shell {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedShell.class);
    private final ResultHandler resultHandler;
    private final List<String> postProcessorNames = new ArrayList<String>();

    public ExtendedShell(ResultHandler resultHandler, List<PostProcessor> postProcessors) {
        super(resultHandler);
        this.resultHandler = resultHandler;
        if (postProcessors != null) {
            this.postProcessorNames.addAll(postProcessors.stream().map(PostProcessor::getName).collect(Collectors.toList()));
        }
    }

    public void run(InputProvider inputProvider) {
        this.run(inputProvider, () -> false);
    }

    public void run(InputProvider inputProvider, ShellNotifier shellNotifier) {
        Object result = null;
        while (!(result instanceof ExitRequest) && !shellNotifier.shouldStop()) {
            Input input;
            try {
                input = inputProvider.readInput();
            }
            catch (ExitRequest e) {
                break;
            }
            catch (Exception e) {
                this.resultHandler.handleResult((Object)e);
                continue;
            }
            if (input == null) break;
            result = this.evaluate(input);
            if (result == NO_INPUT || result instanceof ExitRequest) continue;
            this.resultHandler.handleResult(result);
        }
    }

    public Object evaluate(Input input) {
        List words = input.words();
        Object toReturn = super.evaluate((Input)new ExtendedInput(input));
        SshContext ctx = SshShellCommandFactory.SSH_THREAD_CONTEXT.get();
        if (ctx != null) {
            if (!ctx.isBackground()) {
                ctx.getPostProcessorsList().clear();
            }
            if (ExtendedShell.isKeyCharInList(words)) {
                List indexes = IntStream.range(0, words.size()).filter(i -> ExtendedInput.KEY_CHARS.contains(words.get(i))).boxed().collect(Collectors.toList());
                for (Integer index : indexes) {
                    if (words.size() <= index + 1) continue;
                    String keyChar = (String)words.get(index);
                    if (keyChar.equals("|")) {
                        String postProcessorName = (String)words.get(index + 1);
                        int currentIndex = 2;
                        String word = words.size() > index + currentIndex ? (String)words.get(index + currentIndex) : null;
                        ArrayList<String> params = new ArrayList<String>();
                        while (word != null && !ExtendedInput.KEY_CHARS.contains(word)) {
                            params.add(word);
                            word = words.size() > index + ++currentIndex ? (String)words.get(index + currentIndex) : null;
                        }
                        ctx.getPostProcessorsList().add(new PostProcessorObject(postProcessorName, params));
                        continue;
                    }
                    if (!keyChar.equals(">")) continue;
                    ctx.getPostProcessorsList().add(new PostProcessorObject("save", Collections.singletonList((String)words.get(index + 1))));
                }
                LOGGER.debug("Found {} post processors", (Object)ctx.getPostProcessorsList().size());
            }
        }
        return toReturn;
    }

    public List<CompletionProposal> complete(CompletionContext context) {
        if (context.getWords().contains("|")) {
            return this.postProcessorNames.stream().map(CompletionProposal::new).collect(Collectors.toList());
        }
        return super.complete(context);
    }

    private static boolean isKeyCharInList(List<String> strList) {
        for (String key : ExtendedInput.KEY_CHARS) {
            if (!strList.contains(key)) continue;
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface ShellNotifier {
        public boolean shouldStop();
    }
}

