/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluidsonic.fluid.stdlib;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0003*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"atEndOfDay", "Ljava/time/LocalDateTime;", "Ljava/time/LocalDate;", "Ljava/time/ZonedDateTime;", "zone", "Ljava/time/ZoneId;", "fluid-stdlib-jdk8"})
public final class LocalDateKt {
    @NotNull
    public static final LocalDateTime atEndOfDay(@NotNull LocalDate $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        LocalDateTime localDateTime = $receiver.atTime(LocalTime.MAX);
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"atTime(LocalTime.MAX)");
        return localDateTime;
    }

    @NotNull
    public static final ZonedDateTime atEndOfDay(@NotNull LocalDate $receiver, @NotNull ZoneId zone) {
        ZoneRules rules;
        ZoneOffsetTransition transition;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        LocalDateTime localDateTime = $receiver.atTime(LocalTime.MAX);
        if (!(zone instanceof ZoneOffset) && (transition = (rules = zone.getRules()).getTransition(localDateTime)) != null && transition.isGap()) {
            localDateTime = transition.getDateTimeBefore();
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, zone);
        Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"ZonedDateTime.of(localDateTime, zone)");
        return zonedDateTime;
    }
}

