/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluidsonic.fluid.json;

import com.github.fluidsonic.fluid.json.AbstractJSONCodec;
import com.github.fluidsonic.fluid.json.JSONCodingContext;
import com.github.fluidsonic.fluid.json.JSONCodingType;
import com.github.fluidsonic.fluid.json.JSONDecoder;
import com.github.fluidsonic.fluid.json.JSONDecoderKt;
import com.github.fluidsonic.fluid.json.JSONEncoder;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00030\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\bH\u0016J\u001a\u0010\t\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Lcom/github/fluidsonic/fluid/json/LocalDateTimeJSONCodec;", "Lcom/github/fluidsonic/fluid/json/AbstractJSONCodec;", "Ljava/time/LocalDateTime;", "Lcom/github/fluidsonic/fluid/json/JSONCodingContext;", "()V", "decode", "Lcom/github/fluidsonic/fluid/json/JSONDecoder;", "valueType", "Lcom/github/fluidsonic/fluid/json/JSONCodingType;", "encode", "", "Lcom/github/fluidsonic/fluid/json/JSONEncoder;", "value", "fluid-json-coding-jdk8"})
public final class LocalDateTimeJSONCodec
extends AbstractJSONCodec<LocalDateTime, JSONCodingContext> {
    public static final LocalDateTimeJSONCodec INSTANCE;

    @NotNull
    public LocalDateTime decode(@NotNull JSONDecoder<? extends JSONCodingContext> $receiver, @NotNull JSONCodingType<? super LocalDateTime> valueType) {
        LocalDateTime localDateTime;
        String string;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(valueType, (String)"valueType");
        String raw = string = $receiver.readString();
        boolean bl = false;
        try {
            LocalDateTime localDateTime2 = LocalDateTime.parse(raw);
            if (localDateTime2 == null) {
                Intrinsics.throwNpe();
            }
            localDateTime = localDateTime2;
        }
        catch (DateTimeException e) {
            Void void_ = JSONDecoderKt.invalidValueError($receiver, (String)("date and time in ISO-8601 format expected, got '" + raw + '\''));
            throw null;
        }
        return localDateTime;
    }

    public void encode(@NotNull JSONEncoder<? extends JSONCodingContext> $receiver, @NotNull LocalDateTime value) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = value.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.toString()");
        $receiver.writeString(string);
    }

    private LocalDateTimeJSONCodec() {
        super(null, null, 3, null);
    }

    static {
        LocalDateTimeJSONCodec localDateTimeJSONCodec;
        INSTANCE = localDateTimeJSONCodec = new LocalDateTimeJSONCodec();
    }
}

