/*
 * Decompiled with CFR 0.152.
 */
package com.github.ffch.jpamapper.spring.boot.autoconfigure;

import com.github.ffch.jpamapper.core.MapperScanner;
import com.github.ffch.jpamapper.core.mapper.register.MappedStatementRegister;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.ibatis.binding.MapperRegistry;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={SqlSessionFactory.class})
@AutoConfigureAfter(value={MybatisAutoConfiguration.class})
public class JpaMapperAutoConfiguration {
    @Autowired
    private List<SqlSessionFactory> sqlSessionFactoryList;

    @PostConstruct
    public void addPageInterceptor() {
        try {
            MapperScanner mapperScanner = new MapperScanner();
            for (SqlSessionFactory sqlSessionFactory : this.sqlSessionFactoryList) {
                org.apache.ibatis.session.Configuration configuration = sqlSessionFactory.getConfiguration();
                MapperRegistry mapperRegistry = configuration.getMapperRegistry();
                ArrayList mappers = new ArrayList(mapperRegistry.getMappers());
                MappedStatementRegister mappedStatementRegister = new MappedStatementRegister(configuration);
                mappedStatementRegister.addMappers(mappers);
                mapperScanner.addMappedStatementRegister(mappedStatementRegister);
            }
            mapperScanner.scanAndRegisterJpaMethod();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

