/*
 * Decompiled with CFR 0.152.
 */
package com.github.faubertin.http.client.handler;

import com.github.faubertin.http.client.domain.HttpResponse;
import com.github.faubertin.http.client.domain.HttpStatus;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import java.beans.ConstructorProperties;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private static final Logger log = LoggerFactory.getLogger(HttpClientHandler.class);
    private final Consumer<HttpResponse> responseConsumer;

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, FullHttpResponse fullHttpResponse) throws Exception {
        try {
            ByteBuf content = fullHttpResponse.content();
            byte[] contentAsByteArray = new byte[content.readableBytes()];
            content.readBytes(contentAsByteArray);
            this.responseConsumer.accept(new HttpResponse(HttpStatus.forCode(fullHttpResponse.getStatus().code()), (ImmutableMap<String, String>)ImmutableMap.of(), contentAsByteArray));
        }
        catch (Exception e) {
            log.error("Error in HTTP client callback", (Throwable)e);
        }
    }

    @ConstructorProperties(value={"responseConsumer"})
    public HttpClientHandler(Consumer<HttpResponse> responseConsumer) {
        this.responseConsumer = responseConsumer;
    }
}

