/*
 * Decompiled with CFR 0.152.
 */
package com.github.faubertin.http.client.facade;

import com.github.faubertin.http.client.domain.HttpRequest;
import com.github.faubertin.http.client.domain.HttpResponse;
import com.github.faubertin.http.client.facade.HttpClient;
import com.github.faubertin.http.client.handler.HttpClientHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpClient
implements HttpClient {
    private static final Logger log = LoggerFactory.getLogger(SimpleHttpClient.class);
    private final Bootstrap nettyBootstrap;

    @Override
    public void get(HttpRequest httpRequest, Consumer<HttpResponse> callback) {
        this.sendHttpRequest(HttpMethod.GET, httpRequest, callback);
    }

    @Override
    public void post(HttpRequest httpRequest, Consumer<HttpResponse> callback) {
        this.sendHttpRequest(HttpMethod.POST, httpRequest, callback);
    }

    @Override
    public void put(HttpRequest httpRequest, Consumer<HttpResponse> callback) {
        this.sendHttpRequest(HttpMethod.PUT, httpRequest, callback);
    }

    void sendHttpRequest(HttpMethod method, HttpRequest httpRequest, Consumer<HttpResponse> callback) {
        try {
            this.sendHttpRequestInterruptibly(method, httpRequest, callback);
        }
        catch (InterruptedException e) {
            log.warn("Thread interrupted, aborting HTTP request");
            Thread.currentThread().interrupt();
        }
    }

    void sendHttpRequestInterruptibly(HttpMethod method, HttpRequest httpRequest, Consumer<HttpResponse> callback) throws InterruptedException {
        URI uri = this.parseUri(httpRequest.getUrl());
        Channel connection = this.createConnection(uri.getHost(), this.getPort(uri));
        this.addCallbackInvocationToPipeline(connection, callback);
        FullHttpRequest nettyHttpRequest = this.createNettyHttpRequest(method, uri);
        this.writeAndFlush(connection, nettyHttpRequest);
    }

    Channel createConnection(String host, int port) throws InterruptedException {
        return this.nettyBootstrap.connect(host, port).sync().channel();
    }

    void addCallbackInvocationToPipeline(Channel connection, Consumer<HttpResponse> callback) {
        connection.pipeline().addLast("http-client", (ChannelHandler)new HttpClientHandler(httpResponse -> {
            this.closeConnectionSafely(connection);
            callback.accept((HttpResponse)httpResponse);
        }));
    }

    FullHttpRequest createNettyHttpRequest(HttpMethod method, URI uri) {
        DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, uri.getRawPath());
        httpRequest.headers().set("Host", (Object)uri.getHost());
        httpRequest.headers().set("Connection", (Object)"close");
        httpRequest.headers().set("Accept-Encoding", (Object)"gzip");
        return httpRequest;
    }

    void writeAndFlush(Channel connection, FullHttpRequest httpRequest) {
        connection.writeAndFlush((Object)httpRequest).addListener(channelFuture -> {
            if (!channelFuture.isSuccess()) {
                log.error("Error while sending HTTP request", channelFuture.cause());
            }
        });
    }

    void closeConnectionSafely(Channel connection) {
        try {
            connection.close().addListener(channelFuture -> {
                if (!channelFuture.isSuccess()) {
                    log.error("Error while closing connection", channelFuture.cause());
                }
            });
        }
        catch (Exception e) {
            log.error("Error while closing HTTP connection", (Throwable)e);
        }
    }

    URI parseUri(String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL", e);
        }
    }

    int getPort(URI uri) {
        int port = uri.getPort();
        if (port > 0) {
            return port;
        }
        switch (uri.getScheme()) {
            case "http": {
                return 80;
            }
            case "https": {
                return 443;
            }
        }
        throw new IllegalArgumentException("Unknown protocol: " + uri.getScheme());
    }

    @ConstructorProperties(value={"nettyBootstrap"})
    public SimpleHttpClient(Bootstrap nettyBootstrap) {
        this.nettyBootstrap = nettyBootstrap;
    }
}

