/*
 * Decompiled with CFR 0.152.
 */
package com.github.faubertin.http.client.facade;

import com.github.faubertin.http.client.facade.HttpClient;
import com.github.faubertin.http.client.facade.SimpleHttpClient;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;

public class HttpClientBuilder {
    HttpClientBuilder() {
    }

    public HttpClient build() {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)new NioEventLoopGroup(Math.max(1, Runtime.getRuntime().availableProcessors() / 2)));
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel socketChannel) throws Exception {
                ChannelPipeline pipeline = socketChannel.pipeline();
                pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
                pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(0x100000)});
            }
        });
        return new SimpleHttpClient(bootstrap);
    }
}

