/*
 * Decompiled with CFR 0.152.
 */
package com.github.faubertin.http.client.domain;

import com.github.faubertin.http.client.domain.HttpStatus;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.Arrays;

public class HttpResponse {
    private final HttpStatus status;
    private final ImmutableMap<String, String> headers;
    private final byte[] body;

    @ConstructorProperties(value={"status", "headers", "body"})
    public HttpResponse(HttpStatus status, ImmutableMap<String, String> headers, byte[] body) {
        this.status = status;
        this.headers = headers;
        this.body = body;
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public ImmutableMap<String, String> getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpResponse)) {
            return false;
        }
        HttpResponse other = (HttpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpStatus this$status = this.getStatus();
        HttpStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        ImmutableMap<String, String> this$headers = this.getHeaders();
        ImmutableMap<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        return Arrays.equals(this.getBody(), other.getBody());
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 0 : ((Object)((Object)$status)).hashCode());
        ImmutableMap<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 0 : $headers.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        return result;
    }

    public String toString() {
        return "HttpResponse(status=" + (Object)((Object)this.getStatus()) + ", headers=" + this.getHeaders() + ", body=" + Arrays.toString(this.getBody()) + ")";
    }
}

