/*
 * Decompiled with CFR 0.152.
 */
package com.github.faubertin.http.client.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public class HttpRequest {
    private final String url;
    private final Optional<byte[]> body;
    private final ImmutableMap<String, String> headers;

    public static HttpRequestBuilder newBuilder(String url) {
        return new HttpRequestBuilder(url);
    }

    private HttpRequest(String url, Optional<byte[]> body, ImmutableMap<String, String> headers) {
        this.url = url;
        this.body = body;
        this.headers = headers;
    }

    public String getUrl() {
        return this.url;
    }

    public Optional<byte[]> getBody() {
        return this.body;
    }

    public ImmutableMap<String, String> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Optional<byte[]> this$body = this.getBody();
        Optional<byte[]> other$body = other.getBody();
        if (this$body == null ? other$body != null : !((Object)this$body).equals(other$body)) {
            return false;
        }
        ImmutableMap<String, String> this$headers = this.getHeaders();
        ImmutableMap<String, String> other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !this$headers.equals(other$headers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 0 : $url.hashCode());
        Optional<byte[]> $body = this.getBody();
        result = result * 59 + ($body == null ? 0 : ((Object)$body).hashCode());
        ImmutableMap<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 0 : $headers.hashCode());
        return result;
    }

    public String toString() {
        return "HttpRequest(url=" + this.getUrl() + ", body=" + this.getBody() + ", headers=" + this.getHeaders() + ")";
    }

    public static class HttpRequestBuilder {
        @NonNull
        private final String url;
        private byte[] body;
        private ImmutableMap.Builder<String, String> headers;

        private HttpRequestBuilder(String url) {
            Preconditions.checkArgument((!url.trim().isEmpty() ? 1 : 0) != 0, (Object)"Blank URL not allowed");
            this.url = url;
            this.headers = ImmutableMap.builder();
        }

        public HttpRequestBuilder withBody(@NonNull byte[] body) {
            if (body == null) {
                throw new NullPointerException("body");
            }
            this.body = body;
            return this;
        }

        public HttpRequestBuilder withHeader(@NonNull String name, @NonNull String value) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (value == null) {
                throw new NullPointerException("value");
            }
            Preconditions.checkArgument((!name.trim().isEmpty() ? 1 : 0) != 0, (Object)"Blank header name not allowed");
            this.headers.put((Object)name, (Object)value);
            return this;
        }

        public HttpRequestBuilder withHeaders(@NonNull Map<String, String> headers) {
            if (headers == null) {
                throw new NullPointerException("headers");
            }
            this.headers.putAll(headers);
            return this;
        }

        public HttpRequest build() {
            return new HttpRequest(this.url, Optional.ofNullable(this.body), this.headers.build());
        }
    }
}

