package com.github.faubertin.http.client.handler;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import com.github.faubertin.http.client.domain.HttpResponse;
import com.github.faubertin.http.client.domain.HttpStatus;

import java.util.function.Consumer;

@Slf4j
@RequiredArgsConstructor
public class HttpClientHandler extends SimpleChannelInboundHandler<FullHttpResponse> {

    private final Consumer<HttpResponse> responseConsumer;

    @Override
    protected void channelRead0(ChannelHandlerContext channelHandlerContext,
                                FullHttpResponse fullHttpResponse) throws Exception {
        try {
            ByteBuf content = fullHttpResponse.content();
            byte[] contentAsByteArray = new byte[content.readableBytes()];
            content.readBytes(contentAsByteArray);

            responseConsumer.accept(new HttpResponse(
                    HttpStatus.forCode(fullHttpResponse.getStatus().code()),
                    ImmutableMap.of(),
                    contentAsByteArray));
        } catch (Exception e) {
            log.error("Error in HTTP client callback", e);
        }
    }

}
