package com.github.faubertin.http.client.facade;

import com.github.faubertin.http.client.domain.HttpRequest;
import com.github.faubertin.http.client.domain.HttpResponse;

import java.util.function.Consumer;

public interface HttpClient {

    static HttpClientBuilder newBuilder() {
        return new HttpClientBuilder();
    }

    void get(HttpRequest request,
             Consumer<HttpResponse> callback);

    void post(HttpRequest request,
              Consumer<HttpResponse> callback);

    void put(HttpRequest request,
             Consumer<HttpResponse> callback);

}
