/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.net.ftp;

import com.github.fartherp.framework.net.exception.FtpFailException;
import com.github.fartherp.framework.net.ftp.FtpConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUtils {
    public static final Logger log = LoggerFactory.getLogger(FtpUtils.class);

    private static void prepareConnection(FTPClient ftp, FtpConfig config) {
        log.info("prepare.connection:{}", (Object)config);
        try {
            ftp.connect(config.getHost(), config.getPort());
        }
        catch (IOException e) {
            log.error("ftp connect fail[refused,config={}]", (Object)config);
            FtpUtils.setReplyCode(ftp, e);
        }
        try {
            if (config.isBinaryMode()) {
                ftp.setFileType(2);
            } else {
                ftp.setFileType(0);
            }
        }
        catch (IOException e) {
            log.error("ftp set file type fail[refused,config={}]", (Object)config);
            FtpUtils.setReplyCode(ftp, e);
        }
        if (config.isLocalPassiveMode()) {
            ftp.enterLocalPassiveMode();
        } else {
            ftp.enterLocalActiveMode();
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)config.getUsername()) && StringUtils.isNotBlank((CharSequence)config.getPassword())) {
                ftp.user(config.getUsername());
                ftp.pass(config.getPassword());
            }
        }
        catch (IOException e) {
            log.error("ftp set username/password fail[refused,config={}]", (Object)config);
            FtpUtils.setReplyCode(ftp, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(FtpConfig config, String ftpPath, InputStream fileStream, String fileName) {
        log.info("ftp.store[{}]", (Object)config);
        if (StringUtils.isBlank((CharSequence)fileName)) {
            log.error("ftp.store.fileName=blank");
            throw new FtpFailException(0, "File Name is blank");
        }
        FTPClient ftp = new FTPClient();
        FtpUtils.prepareConnection(ftp, config);
        try {
            if (!StringUtils.isBlank((CharSequence)ftpPath)) {
                ftp.changeWorkingDirectory(ftpPath);
            } else {
                ftp.changeWorkingDirectory(config.getDefaultDir());
            }
        }
        catch (IOException e) {
            log.error("ftp.cwd.error:{}", (Throwable)e);
            FtpUtils.closeFtpQuietly(ftp);
            FtpUtils.setReplyCode(ftp, e);
        }
        try {
            ftp.storeFile(fileName, fileStream);
        }
        catch (IOException e) {
            log.error("ftp.store.error:{}", (Throwable)e);
            FtpUtils.setReplyCode(ftp, e);
        }
        finally {
            FtpUtils.closeFtpQuietly(ftp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fetch(FtpConfig config, String path, OutputStream output) {
        log.info("ftp.fetch[{}]", (Object)config);
        FTPClient ftp = new FTPClient();
        FtpUtils.prepareConnection(ftp, config);
        try {
            ftp.retrieveFile(path, output);
        }
        catch (IOException e) {
            log.error("ftp.retrieve.error:{}", (Throwable)e);
            FtpUtils.setReplyCode(ftp, e);
        }
        finally {
            FtpUtils.closeFtpQuietly(ftp);
        }
    }

    private static void setReplyCode(FTPClient ftp, Exception e) {
        int reply = ftp.getReplyCode();
        log.info("reply={}", (Object)reply);
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            throw new FtpFailException(0, e.getMessage());
        }
        String message = ftp.getReplyString();
        if (null == message) {
            message = e.getMessage();
        }
        throw new FtpFailException(reply, message);
    }

    private static void closeFtpQuietly(FTPClient ftp) {
        if (ftp.isConnected()) {
            try {
                ftp.disconnect();
            }
            catch (IOException e) {
                log.error("closeFtpQuietly.error:{}", (Throwable)e);
            }
        }
    }
}

