/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client.sender.producer;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opentsdb.client.bean.request.Point;
import org.opentsdb.client.sender.producer.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerImpl
implements Producer {
    private static final Logger log = LoggerFactory.getLogger(ProducerImpl.class);
    private final BlockingQueue<Point> queue;
    private final AtomicBoolean forbiddenWrite = new AtomicBoolean(false);

    public ProducerImpl(BlockingQueue<Point> queue) {
        this.queue = queue;
        log.debug("the producer has started");
    }

    @Override
    public void send(Point point) {
        if (this.forbiddenWrite.get()) {
            throw new IllegalStateException("client has been closed.");
        }
        try {
            this.queue.put(point);
        }
        catch (InterruptedException e) {
            log.error("Client Thread been Interrupted.", (Throwable)e);
            e.printStackTrace();
        }
    }

    @Override
    public void forbiddenSend() {
        this.forbiddenWrite.compareAndSet(false, true);
    }
}

