/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client.http;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.opentsdb.client.OpenTSDBConfig;
import org.opentsdb.client.http.callback.GracefulCloseFutureCallBack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    private String host;
    private int port;
    private final CloseableHttpAsyncClient client;
    private final AtomicInteger unCompletedTaskNum;
    private ScheduledExecutorService connectionGcService;

    HttpClient(OpenTSDBConfig config, CloseableHttpAsyncClient client, ScheduledExecutorService connectionGcService) {
        this.host = config.getHost();
        this.port = config.getPort();
        this.client = client;
        this.connectionGcService = connectionGcService;
        this.unCompletedTaskNum = new AtomicInteger(0);
    }

    public Future<HttpResponse> post(String path, String json) {
        return this.post(path, json, null);
    }

    public Future<HttpResponse> post(String path, String json, FutureCallback<HttpResponse> httpCallback) {
        log.debug("\u53d1\u9001post\u8bf7\u6c42\uff0c\u8def\u5f84:{}\uff0c\u8bf7\u6c42\u5185\u5bb9:{}", (Object)path, (Object)json);
        HttpPost httpPost = new HttpPost(this.getUrl(path));
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{json})) {
            httpPost.addHeader("Content-Type", "application/json");
            httpPost.setEntity((HttpEntity)this.generateStringEntity(json));
        }
        GracefulCloseFutureCallBack responseCallback = null;
        if (httpCallback != null) {
            log.debug("\u7b49\u5f85\u5b8c\u6210\u7684\u4efb\u52a1\u6570:{}", (Object)this.unCompletedTaskNum.incrementAndGet());
            responseCallback = new GracefulCloseFutureCallBack(this.unCompletedTaskNum, httpCallback);
        }
        return this.client.execute((HttpUriRequest)httpPost, responseCallback);
    }

    private String getUrl(String path) {
        return this.host + ":" + this.port + path;
    }

    private StringEntity generateStringEntity(String json) {
        StringEntity stringEntity = new StringEntity(json, Charset.forName("UTF-8"));
        return stringEntity;
    }

    public void start() {
        this.client.start();
    }

    public void gracefulClose() throws IOException {
        this.close(false);
    }

    public void forceClose() throws IOException {
        this.close(true);
    }

    private void close(boolean force) throws IOException {
        if (!force) {
            int i;
            while (this.client.isRunning() && (i = this.unCompletedTaskNum.get()) != 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    log.warn("The thread {} is Interrupted", (Object)Thread.currentThread().getName());
                }
            }
        }
        this.connectionGcService.shutdownNow();
        this.client.close();
    }
}

