/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client.bean.request;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.opentsdb.client.bean.request.SubQuery;

public class Query {
    private String start;
    private String end;
    private Boolean msResolution;
    private Boolean noAnnotations;
    private Boolean globalAnnotations;
    private Boolean showTSUIDs;
    private Boolean showSummary;
    private Boolean showStats;
    private Boolean showQuery;
    private String timezone;
    private Boolean useCalendar;
    private Boolean delete;
    private List<SubQuery> queries;

    public static Builder begin(Long startTimestamp) {
        return new Builder().begin(startTimestamp);
    }

    public static Builder begin(String start) {
        return new Builder().begin(start);
    }

    private void setDelete(Boolean delete) {
        this.delete = delete;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public Boolean getMsResolution() {
        return this.msResolution;
    }

    public Boolean getNoAnnotations() {
        return this.noAnnotations;
    }

    public Boolean getGlobalAnnotations() {
        return this.globalAnnotations;
    }

    public Boolean getShowTSUIDs() {
        return this.showTSUIDs;
    }

    public Boolean getShowSummary() {
        return this.showSummary;
    }

    public Boolean getShowStats() {
        return this.showStats;
    }

    public Boolean getShowQuery() {
        return this.showQuery;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public Boolean getUseCalendar() {
        return this.useCalendar;
    }

    public Boolean getDelete() {
        return this.delete;
    }

    public List<SubQuery> getQueries() {
        return this.queries;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public void setMsResolution(Boolean msResolution) {
        this.msResolution = msResolution;
    }

    public void setNoAnnotations(Boolean noAnnotations) {
        this.noAnnotations = noAnnotations;
    }

    public void setGlobalAnnotations(Boolean globalAnnotations) {
        this.globalAnnotations = globalAnnotations;
    }

    public void setShowTSUIDs(Boolean showTSUIDs) {
        this.showTSUIDs = showTSUIDs;
    }

    public void setShowSummary(Boolean showSummary) {
        this.showSummary = showSummary;
    }

    public void setShowStats(Boolean showStats) {
        this.showStats = showStats;
    }

    public void setShowQuery(Boolean showQuery) {
        this.showQuery = showQuery;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public void setUseCalendar(Boolean useCalendar) {
        this.useCalendar = useCalendar;
    }

    public void setQueries(List<SubQuery> queries) {
        this.queries = queries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query other = (Query)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$start = this.getStart();
        String other$start = other.getStart();
        if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
            return false;
        }
        String this$end = this.getEnd();
        String other$end = other.getEnd();
        if (this$end == null ? other$end != null : !this$end.equals(other$end)) {
            return false;
        }
        Boolean this$msResolution = this.getMsResolution();
        Boolean other$msResolution = other.getMsResolution();
        if (this$msResolution == null ? other$msResolution != null : !((Object)this$msResolution).equals(other$msResolution)) {
            return false;
        }
        Boolean this$noAnnotations = this.getNoAnnotations();
        Boolean other$noAnnotations = other.getNoAnnotations();
        if (this$noAnnotations == null ? other$noAnnotations != null : !((Object)this$noAnnotations).equals(other$noAnnotations)) {
            return false;
        }
        Boolean this$globalAnnotations = this.getGlobalAnnotations();
        Boolean other$globalAnnotations = other.getGlobalAnnotations();
        if (this$globalAnnotations == null ? other$globalAnnotations != null : !((Object)this$globalAnnotations).equals(other$globalAnnotations)) {
            return false;
        }
        Boolean this$showTSUIDs = this.getShowTSUIDs();
        Boolean other$showTSUIDs = other.getShowTSUIDs();
        if (this$showTSUIDs == null ? other$showTSUIDs != null : !((Object)this$showTSUIDs).equals(other$showTSUIDs)) {
            return false;
        }
        Boolean this$showSummary = this.getShowSummary();
        Boolean other$showSummary = other.getShowSummary();
        if (this$showSummary == null ? other$showSummary != null : !((Object)this$showSummary).equals(other$showSummary)) {
            return false;
        }
        Boolean this$showStats = this.getShowStats();
        Boolean other$showStats = other.getShowStats();
        if (this$showStats == null ? other$showStats != null : !((Object)this$showStats).equals(other$showStats)) {
            return false;
        }
        Boolean this$showQuery = this.getShowQuery();
        Boolean other$showQuery = other.getShowQuery();
        if (this$showQuery == null ? other$showQuery != null : !((Object)this$showQuery).equals(other$showQuery)) {
            return false;
        }
        String this$timezone = this.getTimezone();
        String other$timezone = other.getTimezone();
        if (this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone)) {
            return false;
        }
        Boolean this$useCalendar = this.getUseCalendar();
        Boolean other$useCalendar = other.getUseCalendar();
        if (this$useCalendar == null ? other$useCalendar != null : !((Object)this$useCalendar).equals(other$useCalendar)) {
            return false;
        }
        Boolean this$delete = this.getDelete();
        Boolean other$delete = other.getDelete();
        if (this$delete == null ? other$delete != null : !((Object)this$delete).equals(other$delete)) {
            return false;
        }
        List<SubQuery> this$queries = this.getQueries();
        List<SubQuery> other$queries = other.getQueries();
        return !(this$queries == null ? other$queries != null : !((Object)this$queries).equals(other$queries));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Query;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : $start.hashCode());
        String $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : $end.hashCode());
        Boolean $msResolution = this.getMsResolution();
        result = result * 59 + ($msResolution == null ? 43 : ((Object)$msResolution).hashCode());
        Boolean $noAnnotations = this.getNoAnnotations();
        result = result * 59 + ($noAnnotations == null ? 43 : ((Object)$noAnnotations).hashCode());
        Boolean $globalAnnotations = this.getGlobalAnnotations();
        result = result * 59 + ($globalAnnotations == null ? 43 : ((Object)$globalAnnotations).hashCode());
        Boolean $showTSUIDs = this.getShowTSUIDs();
        result = result * 59 + ($showTSUIDs == null ? 43 : ((Object)$showTSUIDs).hashCode());
        Boolean $showSummary = this.getShowSummary();
        result = result * 59 + ($showSummary == null ? 43 : ((Object)$showSummary).hashCode());
        Boolean $showStats = this.getShowStats();
        result = result * 59 + ($showStats == null ? 43 : ((Object)$showStats).hashCode());
        Boolean $showQuery = this.getShowQuery();
        result = result * 59 + ($showQuery == null ? 43 : ((Object)$showQuery).hashCode());
        String $timezone = this.getTimezone();
        result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
        Boolean $useCalendar = this.getUseCalendar();
        result = result * 59 + ($useCalendar == null ? 43 : ((Object)$useCalendar).hashCode());
        Boolean $delete = this.getDelete();
        result = result * 59 + ($delete == null ? 43 : ((Object)$delete).hashCode());
        List<SubQuery> $queries = this.getQueries();
        result = result * 59 + ($queries == null ? 43 : ((Object)$queries).hashCode());
        return result;
    }

    public String toString() {
        return "Query(start=" + this.getStart() + ", end=" + this.getEnd() + ", msResolution=" + this.getMsResolution() + ", noAnnotations=" + this.getNoAnnotations() + ", globalAnnotations=" + this.getGlobalAnnotations() + ", showTSUIDs=" + this.getShowTSUIDs() + ", showSummary=" + this.getShowSummary() + ", showStats=" + this.getShowStats() + ", showQuery=" + this.getShowQuery() + ", timezone=" + this.getTimezone() + ", useCalendar=" + this.getUseCalendar() + ", delete=" + this.getDelete() + ", queries=" + this.getQueries() + ")";
    }

    public static class Builder {
        private Long startTimestamp;
        private Long endTimestamp;
        private String start;
        private String end;
        private Boolean msResolution;
        private Boolean noAnnotations;
        private Boolean globalAnnotations;
        private Boolean showTSUIDs;
        private Boolean showSummary;
        private Boolean showStats;
        private Boolean showQuery;
        private String timezone;
        private Boolean useCalendar;
        private List<SubQuery> queries = new ArrayList<SubQuery>();

        public Query build() {
            Query query = new Query();
            if (this.startTimestamp == null && StringUtils.isBlank((CharSequence)this.start)) {
                throw new IllegalArgumentException("the start time must be set");
            }
            if (CollectionUtils.isEmpty(this.queries)) {
                throw new IllegalArgumentException("the subQueries must be set");
            }
            query.queries = this.queries;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.start})) {
                query.start = this.start;
            } else if (this.startTimestamp != null) {
                query.start = this.startTimestamp.toString();
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.end})) {
                query.end = this.end;
            } else if (this.endTimestamp != null) {
                query.end = this.endTimestamp.toString();
            }
            query.msResolution = this.msResolution;
            query.noAnnotations = this.noAnnotations;
            query.globalAnnotations = this.globalAnnotations;
            query.showTSUIDs = this.showTSUIDs;
            query.showSummary = this.showSummary;
            query.showStats = this.showStats;
            query.showQuery = this.showQuery;
            query.timezone = this.timezone;
            query.useCalendar = this.useCalendar;
            return query;
        }

        public Builder begin(Long startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public Builder end(Long endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public Builder begin(String start) {
            this.start = start;
            return this;
        }

        public Builder end(String end) {
            this.end = end;
            return this;
        }

        public Builder msResolution() {
            this.msResolution = true;
            return this;
        }

        public Builder noAnnotations() {
            this.noAnnotations = true;
            return this;
        }

        public Builder globalAnnotations() {
            this.globalAnnotations = true;
            return this;
        }

        public Builder showTSUIDs() {
            this.showTSUIDs = true;
            return this;
        }

        public Builder showSummary() {
            this.showSummary = true;
            return this;
        }

        public Builder showStats() {
            this.showStats = true;
            return this;
        }

        public Builder showQuery() {
            this.showQuery = true;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder useCalendar() {
            this.useCalendar = true;
            return this;
        }

        public Builder sub(SubQuery subQuery) {
            this.queries.add(subQuery);
            return this;
        }

        public Builder sub(List<SubQuery> subQueryList) {
            if (!CollectionUtils.isEmpty(subQueryList)) {
                this.queries.addAll(subQueryList);
            }
            return this;
        }
    }
}

