/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client;

import org.opentsdb.client.http.callback.BatchPutHttpResponseCallback;

public class OpenTSDBConfig {
    private String host;
    private int port;
    private int httpConnectionPool;
    private int httpConnectTimeout;
    private int putConsumerThreadCount;
    private int batchPutSize;
    private int batchPutBufferSize;
    private int batchPutTimeLimit;
    private boolean readonly;
    private BatchPutHttpResponseCallback.BatchPutCallBack batchPutCallBack;

    public static Builder address(String host, int port) {
        return new Builder(host, port);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getHttpConnectionPool() {
        return this.httpConnectionPool;
    }

    public int getHttpConnectTimeout() {
        return this.httpConnectTimeout;
    }

    public int getPutConsumerThreadCount() {
        return this.putConsumerThreadCount;
    }

    public int getBatchPutSize() {
        return this.batchPutSize;
    }

    public int getBatchPutBufferSize() {
        return this.batchPutBufferSize;
    }

    public int getBatchPutTimeLimit() {
        return this.batchPutTimeLimit;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public BatchPutHttpResponseCallback.BatchPutCallBack getBatchPutCallBack() {
        return this.batchPutCallBack;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHttpConnectionPool(int httpConnectionPool) {
        this.httpConnectionPool = httpConnectionPool;
    }

    public void setHttpConnectTimeout(int httpConnectTimeout) {
        this.httpConnectTimeout = httpConnectTimeout;
    }

    public void setPutConsumerThreadCount(int putConsumerThreadCount) {
        this.putConsumerThreadCount = putConsumerThreadCount;
    }

    public void setBatchPutSize(int batchPutSize) {
        this.batchPutSize = batchPutSize;
    }

    public void setBatchPutBufferSize(int batchPutBufferSize) {
        this.batchPutBufferSize = batchPutBufferSize;
    }

    public void setBatchPutTimeLimit(int batchPutTimeLimit) {
        this.batchPutTimeLimit = batchPutTimeLimit;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public void setBatchPutCallBack(BatchPutHttpResponseCallback.BatchPutCallBack batchPutCallBack) {
        this.batchPutCallBack = batchPutCallBack;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenTSDBConfig)) {
            return false;
        }
        OpenTSDBConfig other = (OpenTSDBConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getHttpConnectionPool() != other.getHttpConnectionPool()) {
            return false;
        }
        if (this.getHttpConnectTimeout() != other.getHttpConnectTimeout()) {
            return false;
        }
        if (this.getPutConsumerThreadCount() != other.getPutConsumerThreadCount()) {
            return false;
        }
        if (this.getBatchPutSize() != other.getBatchPutSize()) {
            return false;
        }
        if (this.getBatchPutBufferSize() != other.getBatchPutBufferSize()) {
            return false;
        }
        if (this.getBatchPutTimeLimit() != other.getBatchPutTimeLimit()) {
            return false;
        }
        if (this.isReadonly() != other.isReadonly()) {
            return false;
        }
        BatchPutHttpResponseCallback.BatchPutCallBack this$batchPutCallBack = this.getBatchPutCallBack();
        BatchPutHttpResponseCallback.BatchPutCallBack other$batchPutCallBack = other.getBatchPutCallBack();
        return !(this$batchPutCallBack == null ? other$batchPutCallBack != null : !this$batchPutCallBack.equals(other$batchPutCallBack));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenTSDBConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        result = result * 59 + this.getHttpConnectionPool();
        result = result * 59 + this.getHttpConnectTimeout();
        result = result * 59 + this.getPutConsumerThreadCount();
        result = result * 59 + this.getBatchPutSize();
        result = result * 59 + this.getBatchPutBufferSize();
        result = result * 59 + this.getBatchPutTimeLimit();
        result = result * 59 + (this.isReadonly() ? 79 : 97);
        BatchPutHttpResponseCallback.BatchPutCallBack $batchPutCallBack = this.getBatchPutCallBack();
        result = result * 59 + ($batchPutCallBack == null ? 43 : $batchPutCallBack.hashCode());
        return result;
    }

    public String toString() {
        return "OpenTSDBConfig(host=" + this.getHost() + ", port=" + this.getPort() + ", httpConnectionPool=" + this.getHttpConnectionPool() + ", httpConnectTimeout=" + this.getHttpConnectTimeout() + ", putConsumerThreadCount=" + this.getPutConsumerThreadCount() + ", batchPutSize=" + this.getBatchPutSize() + ", batchPutBufferSize=" + this.getBatchPutBufferSize() + ", batchPutTimeLimit=" + this.getBatchPutTimeLimit() + ", readonly=" + this.isReadonly() + ", batchPutCallBack=" + this.getBatchPutCallBack() + ")";
    }

    public static class Builder {
        private String host;
        private int port;
        private int httpConnectionPool = 100;
        private int httpConnectTimeout = 100;
        private int putConsumerThreadCount = 2;
        private int batchPutSize = 50;
        private int batchPutBufferSize = 20000;
        private int batchPutTimeLimit = 300;
        private boolean readonly = false;
        private BatchPutHttpResponseCallback.BatchPutCallBack batchPutCallBack;

        public Builder(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public OpenTSDBConfig config() {
            OpenTSDBConfig config = new OpenTSDBConfig();
            config.host = this.host;
            config.port = this.port;
            config.httpConnectTimeout = this.httpConnectTimeout;
            config.httpConnectionPool = this.httpConnectionPool;
            config.putConsumerThreadCount = this.putConsumerThreadCount;
            config.batchPutSize = this.batchPutSize;
            config.batchPutBufferSize = this.batchPutBufferSize;
            config.batchPutTimeLimit = this.batchPutTimeLimit;
            config.readonly = this.readonly;
            config.batchPutCallBack = this.batchPutCallBack;
            return config;
        }

        public Builder httpConnectionPool(int connectionPool) {
            if (connectionPool < 1) {
                throw new IllegalArgumentException("The ConnectionPool can't be less then 1");
            }
            this.httpConnectionPool = connectionPool;
            return this;
        }

        public Builder httpConnectTimeout(int httpConnectTimeout) {
            if (httpConnectTimeout <= 0) {
                throw new IllegalArgumentException("The connectTimtout can't be less then 0");
            }
            this.httpConnectTimeout = httpConnectTimeout;
            return this;
        }

        public Builder putConsumerThreadCount(int putConsumerThreadCount) {
            if (putConsumerThreadCount < 1) {
                throw new IllegalArgumentException("The threadCount can't be less then 1");
            }
            this.putConsumerThreadCount = putConsumerThreadCount;
            return this;
        }

        public Builder batchPutSize(int batchPutSize) {
            if (batchPutSize < 1) {
                throw new IllegalArgumentException("The size can't be less then 1");
            }
            this.batchPutSize = batchPutSize;
            return this;
        }

        public Builder batchPutBufferSize(int batchPutBufferSize) {
            if (batchPutBufferSize < 1) {
                throw new IllegalArgumentException("The size can't be less then 1");
            }
            this.batchPutBufferSize = batchPutBufferSize;
            return this;
        }

        public Builder batchPutTimeLimit(int batchPutTimeLimit) {
            if (batchPutTimeLimit < 1) {
                throw new IllegalArgumentException("The time limit can't be less then 1");
            }
            this.batchPutTimeLimit = batchPutTimeLimit;
            return this;
        }

        public Builder readonly() {
            this.readonly = true;
            return this;
        }

        public Builder batchPutCallBack(BatchPutHttpResponseCallback.BatchPutCallBack batchPutCallBack) {
            this.batchPutCallBack = batchPutCallBack;
            return this;
        }
    }
}

